﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
*   @file
*   @brief  追加コンテンツの API 宣言
*/

#pragma once

#include <nn/nn_Result.h>
#include <nn/nn_Common.h>
#include <nn/nn_ApplicationId.h>
#include <nn/aoc/aoc_Types.h>

namespace nn { namespace aoc {
    //! @name 初期化と終了処理
    //! @{

        /**
         * @brief   追加コンテンツライブラリの初期化をおこない、機能を使用可能な状態にします。
         *
         * @details
         *  追加コンテンツライブラリが提供する API は、利用前にこの関数でライブラリを初期化しておく必要があります。@n
         *
         *  ライブラリがすでに初期化された状態でも重ねて呼ぶことができますが、その場合、ライブラリの利用を完全に終了するにはこの関数を呼んだのと同じ回数だけ
         *  @ref nn::aoc::Finalize 関数を呼ぶ必要があります。
         */
        void Initialize() NN_NOEXCEPT;

        /**
         * @brief   追加コンテンツライブラリの利用を終了します。
         *
         *
         * @details
         *  @ref nn::aoc::Initialize 関数を複数回呼んでいる場合、追加コンテンツライブラリの利用を完全に終了するには同じ回数だけこの関数を呼ぶ必要があります。@n
         *
         *  ライブラリの利用が完全に終了されると、システムで確保していたリソースが解放ます。@n
         *  ライブラリが未初期化の状態でコールしても副作用はありません。
         */
        void Finalize() NN_NOEXCEPT;
    //! @}

    nn::Bit64 GetAddOnContentBaseId() NN_NOEXCEPT;
    nn::Bit64 GetAddOnContentBaseId(nn::ApplicationId targetApplication) NN_NOEXCEPT;
    nn::Result PrepareAddOnContent(nn::aoc::AddOnContentIndex targetIndex) NN_NOEXCEPT;
    nn::Result PrepareAddOnContent(nn::aoc::AddOnContentIndex targetIndex, nn::ApplicationId targetApplication) NN_NOEXCEPT;
//! @}
}} // namespace nn::aoc
