﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <memory>

#include <nn/am/service/window/am_CommonWindowProperty.h>

namespace nn { namespace am { namespace service { namespace window {

class Window;

template <typename>
struct WindowControllerBase
{
    struct CalculationContext {};
    void InitializeCalculationContext(CalculationContext*) NN_NOEXCEPT {}

    struct EventStatus {};
    struct EventType {};

    template <typename Status>
    static void UpdateNegativeImmediately(Window*, const Status&, const Status&) NN_NOEXCEPT {}
    template <typename Status>
    static void UpdateNegative(Window*, const Status&, const Status&) NN_NOEXCEPT {}
    template <typename Status>
    static void UpdateImmediately(Window*, const Status&, const Status&) NN_NOEXCEPT {}
    template <typename Status>
    static void UpdatePositive(Window*, const Status&, const Status&) NN_NOEXCEPT {}
    template <typename Status>
    static void UpdatePositiveImmediately(Window*, const Status&, const Status&) NN_NOEXCEPT {}

    template <typename Status>
    static bool AreEqual(const Status&, const Status&) NN_NOEXCEPT
    {
        return false;
    }
};

namespace detail {

template <typename... Infos>
struct IntegratedWindowController;

template <>
struct IntegratedWindowController<>
{
    struct Status {};
    struct Property {};
    struct CalculationContext {};
    struct EventStatus {};
    struct EventType {};

    static void SetNotActive(Status*) NN_NOEXCEPT {}
    void InitializeCalculationContext(CalculationContext*) NN_NOEXCEPT {}
    void CalculateStatus(Status*, const CommonWindowProperty&, const Property&, CalculationContext*) NN_NOEXCEPT {}
    static void UpdateNegativeImmediately(Window*, const Status&, const Status&) NN_NOEXCEPT {}
    static void UpdateNegative(Window*, const Status&, const Status&) NN_NOEXCEPT {}
    static void UpdateImmediately(Window*, const Status&, const Status&) NN_NOEXCEPT {}
    static void UpdatePositive(Window*, const Status&, const Status&) NN_NOEXCEPT {}
    static void UpdatePositiveImmediately(Window*, const Status&, const Status&) NN_NOEXCEPT {}
};

template <typename Info, typename... Infos>
struct IntegratedWindowController<Info, Infos...>
    : public Info
    , public IntegratedWindowController<Infos...>
{
private:

    typedef IntegratedWindowController<Infos...> Rest;

public:

    struct Status
        : public Info::Status
        , public Rest::Status
    {
    };

    struct Property
        : public Info::Property
        , public Rest::Property
    {
    };

    struct CalculationContext
        : public Info::CalculationContext
        , public Rest::CalculationContext
    {
    };

    struct EventStatus
        : public Info::EventStatus
        , public Rest::EventStatus
    {
    };

    void InitializeCalculationContext(CalculationContext* pContext) NN_NOEXCEPT
    {
        Info::InitializeCalculationContext(pContext);
        Rest::InitializeCalculationContext(pContext);
    }

    void CalculateStatus(Status* pOut, const CommonWindowProperty& commonProp, const Property& prop, CalculationContext* pContext) NN_NOEXCEPT
    {
        Info::CalculateStatus(pOut, commonProp, prop, pContext);
        Rest::CalculateStatus(pOut, commonProp, prop, pContext);
    }

    static void SetNotActive(Status* p) NN_NOEXCEPT
    {
        Info::SetNotActive(p);
        Rest::SetNotActive(p);
    }

    static void UpdateNegativeImmediately(Window* p, const Status& oldStatus, const Status& newStatus) NN_NOEXCEPT
    {
        Rest::UpdateNegativeImmediately(p, oldStatus, newStatus);
        if (!Info::AreEqual(oldStatus, newStatus))
        {
            Info::UpdateNegativeImmediately(p, oldStatus, newStatus);
        }
    }

    static void UpdateNegative(Window* p, const Status& oldStatus, const Status& newStatus) NN_NOEXCEPT
    {
        Rest::UpdateNegative(p, oldStatus, newStatus);
        if (!Info::AreEqual(oldStatus, newStatus))
        {
            Info::UpdateNegative(p, oldStatus, newStatus);
        }
    }

    static void UpdateImmediately(Window* p, const Status& oldStatus, const Status& newStatus) NN_NOEXCEPT
    {
        Rest::UpdateImmediately(p, oldStatus, newStatus);
        if (!Info::AreEqual(oldStatus, newStatus))
        {
            Info::UpdateImmediately(p, oldStatus, newStatus);
        }
    }

    static void UpdatePositive(Window* p, const Status& oldStatus, const Status& newStatus) NN_NOEXCEPT
    {
        if (!Info::AreEqual(oldStatus, newStatus))
        {
            Info::UpdatePositive(p, oldStatus, newStatus);
        }
        Rest::UpdatePositive(p, oldStatus, newStatus);
    }

    static void UpdatePositiveImmediately(Window* p, const Status& oldStatus, const Status& newStatus) NN_NOEXCEPT
    {
        if (!Info::AreEqual(oldStatus, newStatus))
        {
            Info::UpdatePositiveImmediately(p, oldStatus, newStatus);
        }
        Rest::UpdatePositiveImmediately(p, oldStatus, newStatus);
    }

};

struct DummyWindowController
    : public WindowControllerBase<DummyWindowController>
{
    struct Status {};
    struct Property {};
    void CalculateStatus(Status*, const CommonWindowProperty&, const Property&, CalculationContext*) NN_NOEXCEPT {}
    static void SetNotActive(Status*) NN_NOEXCEPT {}
};

} // detail

}}}}
