﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <memory>
#include <utility>

#include <nn/am/service/window/am_WindowController.h>
#include <nn/am/service/window/am_IWindowTransiter.h>

namespace nn { namespace am { namespace service { namespace window {

class WindowManager;
class WindowGroup;

class Window
{
    friend WindowManager;
public:

    Window(WindowManager* pManager, std::shared_ptr<WindowGroup> pGroup, IWindowTransiter* pTransiter, const WindowProperty& windowProperty) NN_NOEXCEPT
        : m_pManager(pManager)
        , m_pGroup(std::move(pGroup))
        , m_pTransiter(pTransiter)
        , m_Property(windowProperty)
    {
    }

    void SetSubOrder(uint32_t subOrder) NN_NOEXCEPT
    {
        this->m_SubOrder = subOrder;
    }

    const std::shared_ptr<WindowGroup>& GetWindowGroup() const NN_NOEXCEPT
    {
        return m_pGroup;
    }

    IWindowTransiter* GetTransiter() const NN_NOEXCEPT
    {
        return m_pTransiter;
    }

    WindowEventStatus& RefEventStatus() NN_NOEXCEPT
    {
        return m_EventStatus;
    }

private:

    // これらの必要性の検討
    const WindowProperty& GetProperty() const NN_NOEXCEPT
    {
        return m_Property;
    }

    const WindowStatus& GetCurrentStatus() const NN_NOEXCEPT
    {
        return m_WindowStatus;
    }

    void SetCurrentStatus(const WindowStatus& status) NN_NOEXCEPT
    {
        this->m_WindowStatus = status;
    }

    WindowManager* m_pManager;
    std::shared_ptr<WindowGroup> m_pGroup;
    IWindowTransiter* m_pTransiter;
    bool m_IsActive{false};
    uint32_t m_SubOrder{0};
    WindowProperty m_Property;
    WindowStatus m_WindowStatus{};
    WindowEventStatus m_EventStatus{};

};

}}}}
