﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/nn_TimeSpan.h>
#include <nn/am/service/am_CommonTypes.h>
#include <nn/applet/applet_Types.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/os/os_Types.h>

namespace nn { namespace am { namespace service { namespace window {

class IWindowTransiter
{
public:

    // audio
    virtual void SetEffectiveVolume(bool available, float volume) NN_NOEXCEPT
    {
        NN_UNUSED(available);
        NN_UNUSED(volume);
    }

    // foreground
    virtual void SetForeground(WindowFocusState state, bool canUseApplicationCoreAsRequested) NN_NOEXCEPT
    {
        NN_UNUSED(state);
        NN_UNUSED(canUseApplicationCoreAsRequested);
    }

    virtual void SetCanRun(bool canRun) NN_NOEXCEPT
    {
        NN_UNUSED(canRun);
    }

    // home
    virtual void OnHomeButtonShortPressed() NN_NOEXCEPT
    {
    }

    virtual void OnHomeButtonLongPressed() NN_NOEXCEPT
    {
    }

    // power
    virtual void OnPowerButtonShortPressed() NN_NOEXCEPT
    {
    }

    virtual void OnPowerButtonMiddlePressed() NN_NOEXCEPT
    {
    }

    virtual void OnPowerButtonLongPressed() NN_NOEXCEPT
    {
    }

    // capture
    virtual void OnCaptureButtonShortPressed() NN_NOEXCEPT
    {
    }

    virtual void OnCaptureButtonLongPressed() NN_NOEXCEPT
    {
    }

    // sleep
    virtual void SetLcd(bool onLcd) NN_NOEXCEPT
    {
        NN_UNUSED(onLcd);
    }

    virtual void RequestApprovalForSleep(uint64_t clock) NN_NOEXCEPT
    {
        NN_UNUSED(clock);
    }

    virtual void OnSleepRequiredByHighTemperature() NN_NOEXCEPT
    {
    }

    virtual void OnSleepRequiredByLowBattery() NN_NOEXCEPT
    {
    }

    virtual void OnCecSystemStandbyReceived() NN_NOEXCEPT
    {
    }

    virtual void SetCecStateAndNotifyChanged(bool disablesOneTouchPlayCecNotification) NN_NOEXCEPT
    {
        NN_UNUSED(disablesOneTouchPlayCecNotification);
    }

    virtual void OnAutoPowerDown() NN_NOEXCEPT
    {
    }

    virtual void OnSleepLockAcquired() NN_NOEXCEPT
    {
    }

    virtual void OnSleepLockReleased() NN_NOEXCEPT
    {
    }

    virtual void TransitSleepSequence(SleepSequenceStage stage) NN_NOEXCEPT
    {
        NN_UNUSED(stage);
    }

    virtual void BeforeSleepSystem() NN_NOEXCEPT
    {
    }

    virtual void AfterSleepSystem() NN_NOEXCEPT
    {
    }

    virtual void OnFatal() NN_NOEXCEPT
    {
    }

    virtual void OnProcessException(const os::ProcessId&) NN_NOEXCEPT
    {
    }

    // Idle
    virtual void SetHandlingContextToIdle() NN_NOEXCEPT
    {
    }

    virtual void RequestToSetHandlingContextToIdle() NN_NOEXCEPT
    {
    }

    // nfc
    virtual void NotifyForegroundToNfc() NN_NOEXCEPT
    {
    }

    // hid
    virtual void NotifyHidInputRequirement(bool needInput) NN_NOEXCEPT
    {
        NN_UNUSED(needInput);
    }
    virtual void NotifyHidNpadPolicyOwner() NN_NOEXCEPT
    {
    }

    // IrSensor
    virtual void NotifyIrSensorInputRequirement(bool needInput) NN_NOEXCEPT
    {
        NN_UNUSED(needInput);
    }
    virtual void NotifyIrSensorPolicyOwner() NN_NOEXCEPT
    {
    }

    // HidBus
    virtual void NotifyHidBusPolicyOwner() NN_NOEXCEPT
    {
    }

    // Vibration
    virtual void NotifyVibrationOwner(bool isOwner) NN_NOEXCEPT
    {
        NN_UNUSED(isOwner);
    }

    // SixAxisSensor
    virtual void NotifySixAxisSensorInputRequirement(bool needInput) NN_NOEXCEPT
    {
        NN_UNUSED(needInput);
    }

    // BLE
    virtual void NotifyBleConnectionOwner() NN_NOEXCEPT
    {
    }

    // operation mode
    virtual void OnOperationModeChanged() NN_NOEXCEPT
    {
    }

    // performance mode
    virtual void OnPerformanceModeChanged() NN_NOEXCEPT
    {
    }

    // display
    virtual void SetDisplayVisibility(bool isVisible, int32_t zOrder, bool staysDisplay) NN_NOEXCEPT
    {
        NN_UNUSED(isVisible);
        NN_UNUSED(zOrder);
        NN_UNUSED(staysDisplay);
    }

    virtual void RequestToDisplay(uint64_t clock) NN_NOEXCEPT
    {
        NN_UNUSED(clock);
    }

    // sd card removed
    virtual void OnSdCardRemoved() NN_NOEXCEPT
    {
    }

    // game card
    virtual void OnGameCardStateChanged() NN_NOEXCEPT
    {
    }

    // VR mode
    virtual void OnVrModeChanged(bool isVrMode, bool fromOe) NN_NOEXCEPT
    {
        NN_UNUSED(isVrMode);
        NN_UNUSED(fromOe);
    }

    virtual void OnVrModeCurtainRequired() NN_NOEXCEPT
    {
    }

    // LCD Backlight
    virtual void OnLcdBacklightChanged(bool isLcdBacklightOff) NN_NOEXCEPT
    {
        NN_UNUSED(isLcdBacklightOff);
    }

    virtual void SwitchLcdBacklightOnByForce() NN_NOEXCEPT
    {
    }

    // ScreenShot
    virtual Result SetScreenShotAppletIdentityInfoImpl(applet::AppletIdentityInfo) NN_NOEXCEPT
    {
        NN_RESULT_SUCCESS;
    }

    // Game Play Recording
    virtual void OnGamePlayRecordingStateChanged() NN_NOEXCEPT
    {
    }

    virtual void SetGamePlayRecordingVisibility(bool isVisible) NN_NOEXCEPT
    {
        NN_UNUSED(isVisible);
    }

    // WLAN priority mode
    virtual void OnWirelessPriorityModeChanged(WirelessPriorityMode mode) NN_NOEXCEPT
    {
        NN_UNUSED(mode);
    }
};

namespace detail {
    extern IWindowTransiter g_NullTransiter;
}

inline IWindowTransiter* GetNullTransiter() NN_NOEXCEPT
{
    return &detail::g_NullTransiter;
}

}}}}
