﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/util/util_Optional.h>
#include <nn/os.h>
#include "am_ScreenShotRequest.h"
#include "am_DisplayWorker.h"

namespace nn{ namespace am{ namespace service{ namespace display{

    // スクリーンショット撮影要求のキュー。
    // キューと言っても連続した要求は一つにまとめるので最大 1 つしかエントリーを持たない。
    class ScreenShotRequestQueue
    {
    public:
        void Initialize(DisplayWorker* pWorker, void (*function)(const ScreenShotRequest&, void*), void* userPtr) NN_NOEXCEPT;
        void Finalize() NN_NOEXCEPT;

        void EnqueueRequest(const ScreenShotRequest& request) NN_NOEXCEPT;

    private:
        static void OnRequestEnqueuedCallbackFunction(nn::os::MultiWaitHolderType* pHolder, void* arg) NN_NOEXCEPT;
        void OnRequestEnqueuedImpl() NN_NOEXCEPT;

    private:
        nn::util::optional<ScreenShotRequest> m_Entry;
        nn::os::MutexType m_Mutex;
        nn::os::EventType m_HasEntryEvent;
        nn::os::MultiWaitHolderType m_HasEntryHolder;

        DisplayWorker* m_pWorker;
        void (*m_WorkerFunction)(const ScreenShotRequest&, void*);
        void* m_WorkerUserPointer;
    };

}}}}
