﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/vi/sf/vi_ServiceTypes.h>

namespace nn{ namespace am{ namespace service{ namespace display{ namespace detail{

    class DirectLayerVisibilityManager
    {
    public:
        class DumpAccessor
        {
        public:
            void Initialize(DirectLayerVisibilityManager* pObj) NN_NOEXCEPT { m_pObj = pObj; }
            void Finalize() NN_NOEXCEPT { m_pObj = nullptr; }

            nn::vi::LayerId GetLayerId() const NN_NOEXCEPT { return m_pObj->m_LayerId; }
            int GetZOrder() const NN_NOEXCEPT { return m_pObj->m_ZOrder; }

            nn::vi::LayerStackSet GetForegroundStacks()      const NN_NOEXCEPT{ return m_pObj->m_ForegroundStacks; }
            nn::vi::LayerStackSet GetInstantCaptureStacks()  const NN_NOEXCEPT{ return m_pObj->m_InstantCaptureStacks; }
            nn::vi::LayerStackSet GetMovieRecordingStacks()  const NN_NOEXCEPT{ return m_pObj->m_MovieRecordingStacks; }
            nn::vi::LayerStackSet GetDebugScreenshotStacks() const NN_NOEXCEPT{ return m_pObj->m_DebugScreenshotStacks; }

            nn::vi::LayerStackSet GetCurrentStacks() const NN_NOEXCEPT{ return m_pObj->m_CurrentLayerStacks; }
            int GetCurrentZOrder() const NN_NOEXCEPT { return m_pObj->m_CurrentZOrder; }

        private:
            DirectLayerVisibilityManager* m_pObj = nullptr;
        };

    public:
        bool IsInitialized() const NN_NOEXCEPT { return m_IsInitialized; }
        bool IsActive() const NN_NOEXCEPT { return m_IsActive; }

        void Initialize() NN_NOEXCEPT;
        void Finalize() NN_NOEXCEPT;

        void Activate() NN_NOEXCEPT;
        void Deactivate() NN_NOEXCEPT;

        void SetLayerId(nn::vi::LayerId layerId) NN_NOEXCEPT;

        // FG として出画するか
        void SetForegroundVisibility(bool isVisibile, int zOrder, bool isCaptureTarget) NN_NOEXCEPT;

        // CallerApplet 用キャプチャ
        void SetInstantCaptureVisibility(bool isVisible) NN_NOEXCEPT;

        // 常時録画
        void SetMovieRecordingVisibility(bool isVisible) NN_NOEXCEPT;

        // TM 用キャプチャ
        void SetDebugScreenshotVisibility(bool isVisibile) NN_NOEXCEPT;

        const DumpAccessor* GetDumpAccessor() const NN_NOEXCEPT { return &m_DumpAccessor; }

    private:
        void UpdateCurrentLayerConfigImpl(bool isForced) NN_NOEXCEPT;
        void HideCurrentLayerImpl() NN_NOEXCEPT;

    private:
        friend class DumpAccessor;
        bool m_IsInitialized = false;
        bool m_IsActive = false;

        nn::vi::LayerId m_LayerId = {};
        int m_ZOrder = 0;

        nn::vi::LayerStackSet m_ForegroundStacks = {};
        nn::vi::LayerStackSet m_InstantCaptureStacks = {};
        nn::vi::LayerStackSet m_MovieRecordingStacks = {};
        nn::vi::LayerStackSet m_DebugScreenshotStacks = {};

        nn::vi::LayerStackSet m_CurrentLayerStacks = {};
        int m_CurrentZOrder = 0;

        DumpAccessor m_DumpAccessor;
    };

}}}}}
