﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/am/service/core/am_Applet.h>
#include <nn/am/service/am_ServiceStaticAllocator.h>

#include <nn/os/os_Mutex.h>
#include <type_traits>
#include <memory>
#include <list>

namespace nn { namespace am { namespace service { namespace core {

/**
    @brief 親子関係を持つアプレットの基底クラス

    @details
     StackableApplet は 0 個以上の Applet を子として持つことができる。
     親が Join する際には、子の Join も親が行う。

     親への RequestExit や Terminate は、全ての子にも通知される。
*/
class StackableApplet
    : public Applet
{
protected:

    // 子の管理
    void AddChild(std::shared_ptr<Applet> p) NN_NOEXCEPT;
    void CleanJoinableChildren() NN_NOEXCEPT;
    void CleanAllChildren() NN_NOEXCEPT; // 子をすべて Terminate, Join する
    void TerminateAllChildren() NN_NOEXCEPT; // 子をすべて Terminate だけする
    bool AreAnyChildrenLeft() NN_NOEXCEPT;  // 子が残っているか否かを返す

private:

    // pure
    //   One 系関数は、親アプレット固有の機能の提供
    virtual bool TryJoinOne() NN_NOEXCEPT = 0;
    virtual void InitializeMultiWaitHolderOne(os::MultiWaitHolderType* pHolder) NN_NOEXCEPT = 0;
    virtual void TerminateOne() NN_NOEXCEPT = 0;

    // overrides Applet
    virtual void Terminate() NN_NOEXCEPT NN_OVERRIDE final;
    virtual bool TryJoin() NN_NOEXCEPT NN_OVERRIDE final;
    virtual void InitializeMultiWaitHolder(os::MultiWaitHolderType* pHolder) NN_NOEXCEPT NN_OVERRIDE final;

    os::Mutex m_Mutex{false};
    std::list<std::shared_ptr<Applet>, StaticAllocator<std::shared_ptr<Applet>>> m_Children;
    bool m_Terminating{false};

};

}}}}
