﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <utility>
#include <memory>

#include <nn/applet/applet_Types.h>
#include <nn/am/service/am_IntegratedApplet.h>
#include <nn/am/service/am_Foundation.sfdl.h>
#include <nn/am/service/am_Functions.sfdl.h>
#include <nn/am/service/am_AppletProxy.h>
#include <nn/sf/sf_Types.h>

namespace nn { namespace am { namespace service {

class IntegratedOverlayApplet
    : public IntegratedApplet
{
public:

    explicit IntegratedOverlayApplet(AppletSystem* pAppletSystem, applet::AppletId appletId) NN_NOEXCEPT;

    NN_AM_SERVICE_DIAGNOSTICS_DEFINE_APPLET_KIND_STRING("OA")

private:

    // 基本情報
    applet::AppletId m_AppletId;

    virtual window::ForegroundMode GetForegroundMode() const NN_NOEXCEPT NN_OVERRIDE
    {
        return window::ForegroundMode::None;
    }

    virtual GpuResourceGroupId GetGpuResourceGroupId() const NN_NOEXCEPT NN_OVERRIDE
    {
        return GpuResourceGroupId_Overlay;
    }

    // overrides(option)
    //virtual Result Before() NN_NOEXCEPT NN_OVERRIDE;
    //virtual Result After() NN_NOEXCEPT NN_OVERRIDE;
    //virtual void Cleanup() NN_NOEXCEPT NN_OVERRIDE;
    //virtual void RunBehindProcess(process::NsProcess* pProcess) NN_NOEXCEPT NN_OVERRIDE;
    //virtual void RequestExitOne() NN_NOEXCEPT NN_OVERRIDE;

    // overrides IntegratedApplet
    virtual applet::AppletIdentityInfo GetAppletIdentityInfo() NN_NOEXCEPT NN_OVERRIDE final;
    virtual Result CreateProcessImpl(std::shared_ptr<process::NsProcess>* pOut) NN_NOEXCEPT NN_OVERRIDE final;
    virtual std::shared_ptr<process::NsProcess> MakeAttachedProcess(os::ProcessId processId) NN_NOEXCEPT NN_OVERRIDE final;

    // overrides IntegratedApplet
    virtual AppletProxyInfo DoCreateAppletProxy(os::ProcessId processId) NN_NOEXCEPT NN_OVERRIDE;

    // for impl
    std::shared_ptr<IntegratedOverlayApplet> SharedFromThis() NN_NOEXCEPT
    {
        return std::static_pointer_cast<IntegratedOverlayApplet>(this->shared_from_this());
    }

    class OverlayAppletSelfProxyImpl;

public:

    void NotifyApplicationStarted(const ncm::ApplicationId& applicationId) NN_NOEXCEPT;
    void NotifyApplicationRunning(const ncm::ApplicationId& applicationId) NN_NOEXCEPT;
    void NotifyApplicationExited(const ncm::ApplicationId& applicationId) NN_NOEXCEPT;
    void SetVrModeFlag(bool isEnabled, bool fromOe) NN_NOEXCEPT;

private:

    os::Mutex m_ApplicationNotificationMutex{false};
    ncm::ApplicationId m_CurrentApplicationId = ncm::ApplicationId::GetInvalidId();

    ncm::ApplicationId GetCurrentApplicationId() NN_NOEXCEPT;

private:

    // overrieds (window)
    virtual window::WindowProperty GetInitialWindowProperty() NN_NOEXCEPT NN_OVERRIDE
    {
        auto ret = IntegratedApplet::GetInitialWindowProperty();
        ret.isOverlayAppletWindow = true;
        ret.globalOrder = window::WindowGlobalOrder::Overlay;
        ret.handlesHomeButtonShortPressed = false;
        ret.handlesPowerButtonShortPressed = false;
        ret.handlesPowerButtonMiddlePressed = true;
        ret.isMainAppletWindow = false;
        ret.hidInputTakingMode = window::HidWindowController::HidInputTakingMode_Never;
        ret.handlesCaptureButtonShortPressed  = false;
        ret.handlesCaptureButtonLongPressed = false;
        ret.gpuTimeSlicePriority = 1;
        return ret;
    }

    // overrides IntegratedApplet
    virtual bool IsCaptureTarget() NN_NOEXCEPT NN_OVERRIDE
    {
        return false;
    }

public:

    virtual void OnHomeButtonLongPressed() NN_NOEXCEPT NN_OVERRIDE;
    virtual bool IsScreenShotEnabled() NN_NOEXCEPT NN_OVERRIDE;

};

}}}
