﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <utility>
#include <memory>
#include <nn/os/os_Mutex.h>
#include <nn/os/os_SystemEvent.h>

#include <nn/am/service/window/am_WindowSystem.h>

namespace nn { namespace am { namespace service {

namespace window {

enum class SleepSequenceStage : int;

}

class GlobalStateManager
{
public:

    explicit GlobalStateManager(window::WindowManager* pWindowManager) NN_NOEXCEPT;
    ~GlobalStateManager() NN_NOEXCEPT;

    void NotifyStart() NN_NOEXCEPT;
    Result StartSleepSequence() NN_NOEXCEPT;
    Result StartShutdownSequence() NN_NOEXCEPT;
    Result StartRebootSequence() NN_NOEXCEPT;
    Result LoadAndApplyIdlePolicySettings() NN_NOEXCEPT;
    void SignalSleepCancelEvent() NN_NOEXCEPT;

private:
    enum PowerDownType
    {
        PowerDownType_Sleep,
        PowerDownType_Shutdown,
        PowerDownType_Reboot,
    };

    class SleepWindowTransiter;

    window::WindowManager* m_pWindowManager;

    std::shared_ptr<SleepWindowTransiter> m_pTransiter;
    window::Window* m_pShutterWindow;
    window::Window* m_pSleepWindow;

    os::Mutex m_Mutex{false};
    uint64_t m_LastClockForSleep{0};
    PowerDownType m_PowerDownType;
    bool m_Running{false};

    Result StartPowerDownSequenceImpl(PowerDownType type, bool forcePowerDown) NN_NOEXCEPT;
    void TransitSleepSequenceImpl(window::SleepSequenceStage stage) NN_NOEXCEPT;
    void SleepImpl() NN_NOEXCEPT;
    NN_NORETURN void ShutdownImpl() NN_NOEXCEPT;
    NN_NORETURN void RebootImpl() NN_NOEXCEPT;
    void EndSleepSequenceImpl() NN_NOEXCEPT;

    // event
    virtual void OnFinishedSleepSequence() NN_NOEXCEPT {}

    os::SystemEvent m_SleepCancelEvent;
};

}}}
