﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <utility>
#include <memory>

#include <nn/am/service/process/am_WindableApplet.h>
#include <nn/sf/sf_Types.h>
#include <nn/os/os_SdkMutex.h>

namespace nn { namespace am { namespace service {

/**
    @brief アプレット呼び出しとその終了待機を予約する WindableApplet

    @details
     DoReservation は以下を行う。

     - ReserveToStartAndWaitAndUnwindThis(p) が呼ばれていた場合(かつ、ClearReservation が呼ばれていなかった場合)
       - p->Start()
       - p->Join()
       - true を返す
     - そうでなかった場合
       - false を返す
*/
class CallingWindableApplet
    : public process::WindableApplet
{
protected:

    // for IProcessWindingController
    void ReserveToStartAndWaitAndUnwindThis(std::shared_ptr<core::Applet> p) NN_NOEXCEPT;
    void ReserveToStartAndWait(std::shared_ptr<core::Applet> p) NN_NOEXCEPT;
    void ReserveToWindAndUnwind() NN_NOEXCEPT;
    void ClearReservation() NN_NOEXCEPT;

private:

    os::SdkMutex m_Mutex;
    std::shared_ptr<core::Applet> m_ReservedApplet;
    bool m_NeedsUnwind = false;

    // overrides WindableApplet
    virtual bool DoReservation() NN_NOEXCEPT NN_OVERRIDE;

};

}}}
