﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>

#include <nn/os/os_Types.h>
#include <nn/ncm/ncm_ContentMetaId.h>
#include <nn/account/account_Types.h>
#include <nn/settings/settings_Language.h>
#include <nn/oe/oe_ApplicationControlTypes.h>
#include <nn/util/util_UuidTypes.h>
#include <nn/ns/ns_ApplicationControlDataApi.h>
#include <nn/arp/arp_Api.h>
#include <nn/pdm/pdm_Types.h>
#include <nn/am/service/am_ErrorReport.h>

namespace nn { namespace am { namespace service {

// 下のレイヤにそのまま渡す必要がある、などの特別な事情がない限り、
// ns::ApplicationControlProperty を引数に渡さないこと。

Result EnsureSaveData(int64_t* pOut, ncm::ApplicationId applicationId, const account::Uid& uid, const ns::ApplicationControlProperty& controlProperty) NN_NOEXCEPT;
Result GetDesiredLanguage(settings::LanguageCode* pOut, Bit32 supportedLanguageFlag) NN_NOEXCEPT;
Result SetTerminateResult(ncm::ApplicationId id, Result result, const ApplicationErrorReportInfo& info) NN_NOEXCEPT;
Result GetDisplayVersion(oe::DisplayVersion* pOut, std::add_lvalue_reference<const char[16]>::type displayVersion) NN_NOEXCEPT;
Result GetPseudoDeviceId(nn::util::Uuid* pOutId, Bit64 seedForPseudoDeviceId) NN_NOEXCEPT;
Result ExtendSaveData(int64_t* pOut, ncm::ApplicationId applicationId, uint8_t saveDataType, const account::Uid& uid, int64_t saveDataSize, int64_t saveDataJournalSize, const ns::ApplicationControlProperty& controlProperty) NN_NOEXCEPT;
Result GetSaveDataSize(int64_t* pOutSize, int64_t* pOutJournalSize, ncm::ApplicationId applicationId, uint8_t saveDataType, const account::Uid& uid) NN_NOEXCEPT;
Result CreateCacheStorage(int64_t* pOut, int32_t* pOutMedia, ncm::ApplicationId applicationId, uint16_t index, int64_t cacheSotargeSize, int64_t cacheStorageJournalSize, const ns::ApplicationControlProperty& controlProperty) NN_NOEXCEPT;

struct PlayLogQueryPolicy
{
    ns::PlayLogQueryCapability capability;
    ncm::ApplicationId queryableApplicationId[ns::PlayLogQueryableApplicationCountMax];
};
Result QueryApplicationPlayStatistics(int* pOutCount, pdm::ApplicationPlayStatistics outValues[], const nn::ncm::ApplicationId applicationIds[], int count, const PlayLogQueryPolicy& playLogQueryPolicy, ncm::ApplicationId myApplicationId) NN_NOEXCEPT;

}}}
