﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

/**
    @file
    @brief      ae モジュール用の、ログを出力する API の宣言です。
*/

#include <nn/nn_Common.h>
#include <nn/diag/detail/diag_DetailStructuredSdkLog.h>

#define NN_DETAIL_AE_TRACE(...)                     NN_DETAIL_STRUCTURED_SDK_LOG(ae, Trace, 0, ##__VA_ARGS__)
#define NN_DETAIL_AE_TRACE_V1(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(ae, Trace, 1, ##__VA_ARGS__)
#define NN_DETAIL_AE_TRACE_V2(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(ae, Trace, 2, ##__VA_ARGS__)
#define NN_DETAIL_AE_TRACE_V3(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(ae, Trace, 3, ##__VA_ARGS__)

#define NN_DETAIL_AE_INFO(...)                      NN_DETAIL_STRUCTURED_SDK_LOG(ae, Info, 0, ##__VA_ARGS__)
#define NN_DETAIL_AE_INFO_V1(...)                   NN_DETAIL_STRUCTURED_SDK_LOG(ae, Info, 1, ##__VA_ARGS__)
#define NN_DETAIL_AE_INFO_V2(...)                   NN_DETAIL_STRUCTURED_SDK_LOG(ae, Info, 2, ##__VA_ARGS__)
#define NN_DETAIL_AE_INFO_V3(...)                   NN_DETAIL_STRUCTURED_SDK_LOG(ae, Info, 3, ##__VA_ARGS__)

#define NN_DETAIL_AE_WARN(...)                      NN_DETAIL_STRUCTURED_SDK_LOG(ae, Warn, 0, ##__VA_ARGS__)
#define NN_DETAIL_AE_WARN_V1(...)                   NN_DETAIL_STRUCTURED_SDK_LOG(ae, Warn, 1, ##__VA_ARGS__)
#define NN_DETAIL_AE_WARN_V2(...)                   NN_DETAIL_STRUCTURED_SDK_LOG(ae, Warn, 2, ##__VA_ARGS__)
#define NN_DETAIL_AE_WARN_V3(...)                   NN_DETAIL_STRUCTURED_SDK_LOG(ae, Warn, 3, ##__VA_ARGS__)

#define NN_DETAIL_AE_ERROR(...)                     NN_DETAIL_STRUCTURED_SDK_LOG(ae, Error, 0, ##__VA_ARGS__)
#define NN_DETAIL_AE_ERROR_V1(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(ae, Error, 1, ##__VA_ARGS__)
#define NN_DETAIL_AE_ERROR_V2(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(ae, Error, 2, ##__VA_ARGS__)
#define NN_DETAIL_AE_ERROR_V3(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(ae, Error, 3, ##__VA_ARGS__)

#define NN_DETAIL_AE_FATAL(...)                     NN_DETAIL_STRUCTURED_SDK_LOG(ae, Fatal, 0, ##__VA_ARGS__)
#define NN_DETAIL_AE_FATAL_V1(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(ae, Fatal, 1, ##__VA_ARGS__)
#define NN_DETAIL_AE_FATAL_V2(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(ae, Fatal, 2, ##__VA_ARGS__)
#define NN_DETAIL_AE_FATAL_V3(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(ae, Fatal, 3, ##__VA_ARGS__)

#define NN_DETAIL_AE_VTRACE(format, args)           NN_DETAIL_STRUCTURED_SDK_VLOG(ae, Trace, 0, format, args)
#define NN_DETAIL_AE_VTRACE_V1(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(ae, Trace, 1, format, args)
#define NN_DETAIL_AE_VTRACE_V2(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(ae, Trace, 2, format, args)
#define NN_DETAIL_AE_VTRACE_V3(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(ae, Trace, 3, format, args)

#define NN_DETAIL_AE_VINFO(format, args)            NN_DETAIL_STRUCTURED_SDK_VLOG(ae, Info, 0, format, args)
#define NN_DETAIL_AE_VINFO_V1(format, args)         NN_DETAIL_STRUCTURED_SDK_VLOG(ae, Info, 1, format, args)
#define NN_DETAIL_AE_VINFO_V2(format, args)         NN_DETAIL_STRUCTURED_SDK_VLOG(ae, Info, 2, format, args)
#define NN_DETAIL_AE_VINFO_V3(format, args)         NN_DETAIL_STRUCTURED_SDK_VLOG(ae, Info, 3, format, args)

#define NN_DETAIL_AE_VWARN(format, args)            NN_DETAIL_STRUCTURED_SDK_VLOG(ae, Warn, 0, format, args)
#define NN_DETAIL_AE_VWARN_V1(format, args)         NN_DETAIL_STRUCTURED_SDK_VLOG(ae, Warn, 1, format, args)
#define NN_DETAIL_AE_VWARN_V2(format, args)         NN_DETAIL_STRUCTURED_SDK_VLOG(ae, Warn, 2, format, args)
#define NN_DETAIL_AE_VWARN_V3(format, args)         NN_DETAIL_STRUCTURED_SDK_VLOG(ae, Warn, 3, format, args)

#define NN_DETAIL_AE_VERROR(format, args)           NN_DETAIL_STRUCTURED_SDK_VLOG(ae, Error, 0, format, args)
#define NN_DETAIL_AE_VERROR_V1(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(ae, Error, 1, format, args)
#define NN_DETAIL_AE_VERROR_V2(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(ae, Error, 2, format, args)
#define NN_DETAIL_AE_VERROR_V3(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(ae, Error, 3, format, args)

#define NN_DETAIL_AE_VFATAL(format, args)           NN_DETAIL_STRUCTURED_SDK_VLOG(ae, Fatal, 0, format, args)
#define NN_DETAIL_AE_VFATAL_V1(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(ae, Fatal, 1, format, args)
#define NN_DETAIL_AE_VFATAL_V2(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(ae, Fatal, 2, format, args)
#define NN_DETAIL_AE_VFATAL_V3(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(ae, Fatal, 3, format, args)

#define NN_DETAIL_AE_PUT_TRACE(text, length)        NN_DETAIL_STRUCTURED_SDK_PUT(ae, Trace, 0, text, length)
#define NN_DETAIL_AE_PUT_TRACE_V1(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(ae, Trace, 1, text, length)
#define NN_DETAIL_AE_PUT_TRACE_V2(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(ae, Trace, 2, text, length)
#define NN_DETAIL_AE_PUT_TRACE_V3(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(ae, Trace, 3, text, length)

#define NN_DETAIL_AE_PUT_INFO(text, length)         NN_DETAIL_STRUCTURED_SDK_PUT(ae, Info, 0, text, length)
#define NN_DETAIL_AE_PUT_INFO_V1(text, length)      NN_DETAIL_STRUCTURED_SDK_PUT(ae, Info, 1, text, length)
#define NN_DETAIL_AE_PUT_INFO_V2(text, length)      NN_DETAIL_STRUCTURED_SDK_PUT(ae, Info, 2, text, length)
#define NN_DETAIL_AE_PUT_INFO_V3(text, length)      NN_DETAIL_STRUCTURED_SDK_PUT(ae, Info, 3, text, length)

#define NN_DETAIL_AE_PUT_WARN(text, length)         NN_DETAIL_STRUCTURED_SDK_PUT(ae, Warn, 0, text, length)
#define NN_DETAIL_AE_PUT_WARN_V1(text, length)      NN_DETAIL_STRUCTURED_SDK_PUT(ae, Warn, 1, text, length)
#define NN_DETAIL_AE_PUT_WARN_V2(text, length)      NN_DETAIL_STRUCTURED_SDK_PUT(ae, Warn, 2, text, length)
#define NN_DETAIL_AE_PUT_WARN_V3(text, length)      NN_DETAIL_STRUCTURED_SDK_PUT(ae, Warn, 3, text, length)

#define NN_DETAIL_AE_PUT_ERROR(text, length)        NN_DETAIL_STRUCTURED_SDK_PUT(ae, Error, 0, text, length)
#define NN_DETAIL_AE_PUT_ERROR_V1(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(ae, Error, 1, text, length)
#define NN_DETAIL_AE_PUT_ERROR_V2(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(ae, Error, 2, text, length)
#define NN_DETAIL_AE_PUT_ERROR_V3(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(ae, Error, 3, text, length)

#define NN_DETAIL_AE_PUT_FATAL(text, length)        NN_DETAIL_STRUCTURED_SDK_PUT(ae, Fatal, 0, text, length)
#define NN_DETAIL_AE_PUT_FATAL_V1(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(ae, Fatal, 1, text, length)
#define NN_DETAIL_AE_PUT_FATAL_V2(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(ae, Fatal, 2, text, length)
#define NN_DETAIL_AE_PUT_FATAL_V3(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(ae, Fatal, 3, text, length)
