﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief システムアプリケーションの制御に関する API の宣言
 *
 * @details
 *  本ヘッダでは、システムアプレットの制御に関する API を宣言しています。
 *
 */

#pragma once

#include <nn/nn_Common.h>
#include <nn/ae/ae_Types.h>
#include <nn/applet/applet_Storage.h>

namespace nn { namespace ae {

/**
    @brief システムアプリケーションとしての初期化を行います。

    @details
     システムアプリケーションは nnMain() の先頭で本関数を呼んでください。
*/
void InitializeAsSystemApplication() NN_NOEXCEPT;

}}
