﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief   無操作状態の制御に関する API の宣言
 *
 */

#pragma once

#include <nn/nn_Macro.h>
#include <nn/nn_TimeSpan.h>
#include <nn/ae/ae_Types.h>

namespace nn { namespace ae {

//--------------------------------------------------------------------------

//! @name   無操作状態の制御に関する API
//! @{

//--------------------------------------------------------------------------
/**
 * @brief   無操作状態検出の制御パラメータ設定値を読み出し、システムに反映させます。
 *
 * @details
 *  無操作状態を検出した際に働く自動スリープや画面焼け軽減機能に関する
 *  本体設定値を読み出して、即座にシステムに反映させます。
 *
 */
void LoadAndApplyIdlePolicySettings() NN_NOEXCEPT;


//--------------------------------------------------------------------------
/**
 * @brief   ユーザの操作があったことを明示的に宣言し、無操作状態の継続時間のカウントをリセットします。
 *
 * @details
 *  ユーザの操作があったことを明示的に宣言し、
 *  無操作状態の継続時間のカウントをリセットします。
 *
 *  また、システムアプレットで nn::ae::Message_AutoPowerDown に対する
 *  実際のスリープを行なわなかった後に本 API を呼ぶことで、
 *  無操作状態の検出を再開するようになります。
 *
 * @note
 *
 *  本関数は、事前に利用目的や利用シーンについて問題ないことを
 *  SDK チームやリーガル部門と調整してから利用するようにして下さい。
 *
 */
void ReportUserIsActive() NN_NOEXCEPT;


//! @}

//-----------------------------------------------------------------------------

}} // namespace nn::ae

