﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>

namespace nn { namespace ae {

/**
 * @brief   起動モードを示す列挙型です。
 *
 */
enum BootMode
{
    BootMode_Normal,        //!< 通常起動モードです。
    BootMode_Maintenance,   //!< メンテナンス起動モードです。
};

/**
 * @brief   現在の起動モードを取得します。
 *
 */
BootMode GetBootMode() NN_NOEXCEPT;

}} // namespace nn::ae

