﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief   アプリケーションの性質に関する API の宣言
 *
 * @details
 *  本ヘッダでは、アプリケーションの性質に関する API を定義しています。
 *
 */

#pragma once

#include <nn/ae/ae_Types.h>
#include <nn/arp/arp_Types.h>


namespace nn { namespace ae {

/**
    @brief アプリケーションの性質を取得します。

    @param[out] outValue 対象アプリケーションの性質データの格納先
    @param[in]  applicationHandle 対象アプリケーションのハンドル

    @retresult
    @endretresult

    @details
     成功した場合、outValue が指すポインタに取得したデータが格納されます。

*/
Result GetApplicationLaunchProperty(nn::arp::ApplicationLaunchProperty* outValue, ApplicationHandle applicationHandle) NN_NOEXCEPT;

}} // namespace nn::ae

