﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/account/detail/account_CacheBase.h>
#include <nn/account/detail/account_InternalConfig.h>
#include <nn/account/detail/account_InternalTypes.h>
#include <nn/account/detail/account_LocalStorage.h>
#include <nn/account/ndas/account_NdasTypes.h>
#include <nn/account/account_ResultPrivate.h>

#include <utility>

#include <nn/nn_Result.h>

namespace nn { namespace account { namespace ndas {

typedef detail::CacheSearchResultConfig<ResultNdasTokenCacheNotExist, ResultNdasTokenCacheExpired> NdasResultConfig;

struct ApplicationAuthenticationCacheOperator
{
    static bool IsExpired(int64_t expiration) NN_NOEXCEPT;
    static void DeleteCacheData(const std::pair<detail::Uuid, ApplicationMeta>& data, const detail::AbstractLocalStorage& storage) NN_NOEXCEPT;
};

class ApplicationAuthenticationCache
    : public detail::CacheBaseN<detail::NdasAppAuthCacheCountMax, detail::ApplicationInfo, std::pair<detail::Uuid, ApplicationMeta>, ApplicationAuthenticationCacheOperator, NdasResultConfig>
{
private:
    typedef std::pair<detail::Uuid, ApplicationMeta> DataType;
    typedef detail::CacheBaseN<detail::NdasAppAuthCacheCountMax, detail::ApplicationInfo, std::pair<detail::Uuid, ApplicationMeta>, ApplicationAuthenticationCacheOperator, NdasResultConfig> Base;

public:
    void Store(const detail::ApplicationInfo& appInfo, int64_t expiration, const detail::Uuid& cacheId, const ApplicationMeta& meta) NN_NOEXCEPT
    {
        Base::Store(appInfo, expiration, DataType(cacheId, meta));
    }
    Result Load(size_t* pOutActualSize, char* outToken, size_t bufferSize, const detail::ApplicationInfo& appInfo) const NN_NOEXCEPT;
    Result GetMeta(ApplicationMeta* pOutMeta, const detail::ApplicationInfo& appInfo) const NN_NOEXCEPT;
};

}}}
