﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/account/detail/account_InternalConfig.h>
#include <nn/account/nas/account_NasUserTypes.h>

#include <nn/nn_Common.h>

namespace nn {
namespace account {
namespace nas {

struct NasClientInfo
{
    uint64_t clientId;
    char redirectUri[detail::NasCallbackUriLengthMax + 1];
    NN_EXPLICIT_OPERATOR bool() const NN_NOEXCEPT
    {
        return (clientId != 0x00ull);
    }
};
const NasClientInfo InvalidNasClientInfo = {0x00ull, {}};

struct Scope
{
    char data[255 + 1];

    bool IsValid() const NN_NOEXCEPT;
};
struct State
{
    char data[127 + 1];

    bool IsValid() const NN_NOEXCEPT;
};
struct Nonce
{
    char data[127 + 1];

    bool IsValid() const NN_NOEXCEPT;
};

struct NasApplicationAuthorization
{
    char code[detail::NasAuthorizationCodeSizeMax];
    char idToken[detail::NasIdTokenSizeMax];
};

} // ~namespace nn::account::nas
}
}
