﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/account/detail/account_Execution.h>
#include <nn/account/detail/account_InternalTypes.h>
#include <nn/account/detail/account_LocalStorage.h>
#include <nn/account/nas/account_NasInternalTypes.h>
#include <nn/account/account_NintendoAccountTypes.h>
#include <nn/account/account_TypesForSystemServices.h>

#include <curl/curl.h>

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/time/time_PosixTime.h>

namespace nn { namespace account { namespace nas {

class NasOp2Driver
{
private:
    const detail::AbstractLocalStorage& m_Storage;

    static const size_t RequiredBufferSize;

public:
    explicit NasOp2Driver(const detail::AbstractLocalStorage& storage) NN_NOEXCEPT
        : m_Storage(storage)
    {
    }

    Result GetMembership(
        NetworkServiceLicense* pOutLicense, time::PosixTime* pOutExpiration,
        const NintendoAccountId& id, const detail::Uuid& accessTokenCacheId,
        CURL* curlHandle, void* rawBuffer, size_t bufferSize,
        const detail::Cancellable* pCancellable) const NN_NOEXCEPT;
};

}}} // ~namespace nn::account::nas
