﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/account/detail/account_Execution.h>
#include <nn/account/detail/account_InternalTypes.h>
#include <nn/account/detail/account_LocalStorage.h>
#include <nn/account/http/account_OAuthTypes.h>
#include <nn/account/nas/account_NasInternalTypes.h>
#include <nn/account/nas/account_NasTypes.h>
#include <nn/account/ndas/account_NdasOperator.h>
#include <nn/account/account_NintendoAccountTypes.h>
#include <nn/account/account_TypesForSystemServices.h>

#include <curl/curl.h>

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>

namespace nn { namespace account { namespace nas {

class NasLoginDriver
{
private:
    const ndas::NdasOperator& m_NdasOperator;
    const detail::AbstractLocalStorage& m_Storage;

    static const size_t RequiredBufferSize;

public:
    explicit NasLoginDriver(const ndas::NdasOperator& ndasOperator, const detail::AbstractLocalStorage& storage) NN_NOEXCEPT
        : m_NdasOperator(ndasOperator)
        , m_Storage(storage)
    {
    }

    // Authorization Code Grant Flow
    Result GetUrlForAuthorizationRequest(
        char* urlBuffer, size_t urlBufferSize,
        const NasClientInfo& clientInfo, const http::CodeVerifier& codeVerifier,
        const State& state, NintendoAccountAuthorizationPageTheme theme) const NN_NOEXCEPT;

    Result GetUrlForAuthorizationRequestWithIdTokenHint(
        char* urlBuffer, size_t urlBufferSize,
        const NintendoAccountId& id, const NasClientInfo& clientInfo, const http::CodeVerifier& codeVerifier,
        const State& state) const NN_NOEXCEPT;

    Result GetUrlForNnidLinkageRequest(
        char* urlBuffer, size_t urlBufferSize,
        const NintendoAccountId& id, const NasClientInfo& clientInfo,
        const State& state) const NN_NOEXCEPT;

    Result AcquirePrimaryTokens(
        NasCredentialCache* pOutCredentialCache, NasAccessTokenCache* pOutAccessTokenCache,
        const NasClientInfo& clientInfo, const detail::Uuid& codeCacheId, const http::CodeVerifier& codeVerifier,
        CURL* curlHandle, void* rawBuffer, size_t bufferSize,
        const detail::Cancellable* pCancellable = nullptr) const NN_NOEXCEPT;

    Result RefreshAccessToken(
        NasAccessTokenCache* pOutAccessTokenCache,
        const NintendoAccountId& id, const NasClientInfo& clientInfo, const Scope& scope,
        CURL* curlHandle, void* rawBuffer, size_t bufferSize,
        const detail::Cancellable* pCancellable = nullptr) const NN_NOEXCEPT;

    // For Applications
    Result GetUrlForApplicationAuthorizationRequest(
        char* urlBuffer, size_t urlBufferSize,
        const NintendoAccountId& id,
        const NasClientInfo& clientInfo, const Scope& scope, const State& state, const Nonce& nonce) const NN_NOEXCEPT;

    Result AcquireApplicationAuthorizationWithoutPrompt(
        NasApplicationAuthorization* pOutAuthorization,
        const detail::Uuid& accessTokenCacheId,
        const NasClientInfo& clientInfo, const Scope& scope, const State& state, const Nonce& nonce,
        CURL* curlHandle, void* rawBuffer, size_t bufferSize,
        const detail::Cancellable* pCancellable = nullptr) const NN_NOEXCEPT;

    // For Guest login
    Result GetUrlForGuestLoginRequest(
        char* urlBuffer, size_t urlBufferSize,
        const NasClientInfo& clientInfo, const State& state) const NN_NOEXCEPT;
};

}}} // ~namespace nn::account::nas
