﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

// このファイルは SFDL による自動生成ファイルです。
// 手動で変更しないでください。
// This file is auto-generated by the SFDL code generator.
// Do not modify manually.

#include <cstdint>
#include <nn/account/account_NintendoAccountTypes.h>
#include <nn/account/account_Types.h>
#include <nn/account/account_TypesForSystemServices.h>
#include <nn/account/detail/account_IAsyncContext.sfdl.h>
#include <nn/account/detail/account_InternalTypes.h>
#include <nn/account/http/account_Interface.sfdl.h>
#include <nn/account/nas/account_NasTypes.h>
#include <nn/nn_Result.h>
#include <nn/sf/sf_Types.h>
#include <nn/sf/cmif/detail/sf_CmifAutogenInterfaceIncludes.h>
#include <nn/sf/detail/sf_AutogenInterfaceIncludes.h>
#include <nn/sf/impl/detail/sf_AutogenImplIncludes.h>

namespace nn { namespace account { namespace nas { // NOLINT(whitespace/braces)

class IAuthorizationRequest;

class IOAuthProcedureForExternalNsa;

class IOAuthProcedureForNintendoAccountLinkage;

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(IAuthorizationRequest, (::nn::sf::IServiceObject))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(IAuthorizationRequest)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetSessionId, (::nn::sf::Out<::nn::account::detail::Uuid> pOut))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(InvokeWithoutInteractionAsync, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::detail::IAsyncContext>> pOutContext))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(IsAuthorized, (::nn::sf::Out<bool> pOut))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetAuthorizationCode, (::nn::sf::Out<::std::uint32_t> pOutActualSize, const ::nn::sf::OutBuffer& pOut))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetIdToken, (::nn::sf::Out<::std::uint32_t> pOutActualSize, const ::nn::sf::OutBuffer& pOut))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetState, (::nn::sf::Out<::nn::account::nas::State> pOut))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(IAuthorizationRequest)

        ::nn::Result GetSessionId(::nn::sf::Out<::nn::account::detail::Uuid> pOut) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetSessionId, (pOut));
        }

        ::nn::Result InvokeWithoutInteractionAsync(::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::detail::IAsyncContext>> pOutContext) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(InvokeWithoutInteractionAsync, (pOutContext));
        }

        ::nn::Result IsAuthorized(::nn::sf::Out<bool> pOut) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(IsAuthorized, (pOut));
        }

        ::nn::Result GetAuthorizationCode(::nn::sf::Out<::std::uint32_t> pOutActualSize, const ::nn::sf::OutBuffer& pOut) NN_NOEXCEPT
        {
            NN_SF_DETAIL_CALL_INTERNAL_ASSERT_PRE((NN_SF_DETAIL_APPLY_LAMBDA(_, (_.GetPointerUnsafe() != nullptr && _.GetSize() > 0), pOut)), "_.GetPointerUnsafe() != nullptr && _.GetSize() > 0 (where _ = pOut)")
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetAuthorizationCode, (pOutActualSize, pOut));
        }

        ::nn::Result GetIdToken(::nn::sf::Out<::std::uint32_t> pOutActualSize, const ::nn::sf::OutBuffer& pOut) NN_NOEXCEPT
        {
            NN_SF_DETAIL_CALL_INTERNAL_ASSERT_PRE((NN_SF_DETAIL_APPLY_LAMBDA(_, (_.GetPointerUnsafe() != nullptr && _.GetSize() > 0), pOut)), "_.GetPointerUnsafe() != nullptr && _.GetSize() > 0 (where _ = pOut)")
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetIdToken, (pOutActualSize, pOut));
        }

        ::nn::Result GetState(::nn::sf::Out<::nn::account::nas::State> pOut) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetState, (pOut));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class IAuthorizationRequest
    {
    public:
        nn::Result GetSessionId(nn::sf::Out<nn::account::detail::Uuid> pOut) NN_NOEXCEPT;
        nn::Result InvokeWithoutInteractionAsync(nn::sf::Out<nn::sf::SharedPointer<nn::account::detail::IAsyncContext>> pOutContext) NN_NOEXCEPT;
        nn::Result IsAuthorized(nn::sf::Out<bool> pOut) NN_NOEXCEPT;
        nn::Result GetAuthorizationCode(nn::sf::Out<std::uint32_t> pOutActualSize, const nn::sf::OutBuffer& pOut) NN_NOEXCEPT;
        nn::Result GetIdToken(nn::sf::Out<std::uint32_t> pOutActualSize, const nn::sf::OutBuffer& pOut) NN_NOEXCEPT;
        nn::Result GetState(nn::sf::Out<nn::account::nas::State> pOut) NN_NOEXCEPT;
    };
#endif

}}}

#if 0

// Template for implementation users
class Impl
{
public:
    nn::Result GetSessionId(nn::sf::Out<nn::account::detail::Uuid> pOut) NN_NOEXCEPT;
    nn::Result InvokeWithoutInteractionAsync(nn::sf::Out<nn::sf::SharedPointer<nn::account::detail::IAsyncContext>> pOutContext) NN_NOEXCEPT;
    nn::Result IsAuthorized(nn::sf::Out<bool> pOut) NN_NOEXCEPT;
    nn::Result GetAuthorizationCode(nn::sf::Out<std::uint32_t> pOutActualSize, const nn::sf::OutBuffer& pOut) NN_NOEXCEPT;
    nn::Result GetIdToken(nn::sf::Out<std::uint32_t> pOutActualSize, const nn::sf::OutBuffer& pOut) NN_NOEXCEPT;
    nn::Result GetState(nn::sf::Out<nn::account::nas::State> pOut) NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE((::nn::account::nas::IAuthorizationRequest))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetSessionId, (::nn::sf::Out<::nn::account::detail::Uuid> pOut))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetSessionId, (pOut));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(InvokeWithoutInteractionAsync, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::detail::IAsyncContext>> pOutContext))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(InvokeWithoutInteractionAsync, (pOutContext));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(IsAuthorized, (::nn::sf::Out<bool> pOut))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(IsAuthorized, (pOut));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetAuthorizationCode, (::nn::sf::Out<::std::uint32_t> pOutActualSize, const ::nn::sf::OutBuffer& pOut))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetAuthorizationCode, (pOutActualSize, pOut));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetIdToken, (::nn::sf::Out<::std::uint32_t> pOutActualSize, const ::nn::sf::OutBuffer& pOut))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetIdToken, (pOutActualSize, pOut));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetState, (::nn::sf::Out<::nn::account::nas::State> pOut))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetState, (pOut));
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::account::nas::IAuthorizationRequest>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS((::nn::account::nas::IAuthorizationRequest))

    // nn::Result GetSessionId(nn::sf::Out<nn::account::detail::Uuid> pOut) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetSessionId)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOut, (::nn::account::detail::Uuid), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pOut))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOut)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetSessionId)

    // nn::Result InvokeWithoutInteractionAsync(nn::sf::Out<nn::sf::SharedPointer<nn::account::detail::IAsyncContext>> pOutContext) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(InvokeWithoutInteractionAsync)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(10)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(pOutContext, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (pOutContext))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutContext)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(InvokeWithoutInteractionAsync)

    // nn::Result IsAuthorized(nn::sf::Out<bool> pOut) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(IsAuthorized)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(19)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOut, (bool), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pOut))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOut)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(IsAuthorized)

    // nn::Result GetAuthorizationCode(nn::sf::Out<std::uint32_t> pOutActualSize, const nn::sf::OutBuffer& pOut) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetAuthorizationCode)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(20)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(pOut, 0, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (pOut))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutActualSize, (::std::uint32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pOutActualSize))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutActualSize), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOut)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetAuthorizationCode)

    // nn::Result GetIdToken(nn::sf::Out<std::uint32_t> pOutActualSize, const nn::sf::OutBuffer& pOut) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetIdToken)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(21)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(pOut, 0, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (pOut))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutActualSize, (::std::uint32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pOutActualSize))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutActualSize), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOut)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetIdToken)

    // nn::Result GetState(nn::sf::Out<nn::account::nas::State> pOut) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetState)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(22)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(pOut, 0, (::nn::sf::Out<::nn::account::nas::State>), 128, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (pOut))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOut)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetState)

    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::account::detail::Uuid), 16, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::account::nas::State), 128, 1)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::account::nas::IAuthorizationRequest, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY((::nn::account::nas::IAuthorizationRequest))

    // nn::Result GetSessionId(nn::sf::Out<nn::account::detail::Uuid> pOut) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetSessionId, (::nn::sf::Out<::nn::account::detail::Uuid> pOut))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetSessionId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOut)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetSessionId)
    }

    // nn::Result InvokeWithoutInteractionAsync(nn::sf::Out<nn::sf::SharedPointer<nn::account::detail::IAsyncContext>> pOutContext) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(InvokeWithoutInteractionAsync, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::detail::IAsyncContext>> pOutContext))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(InvokeWithoutInteractionAsync)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutContext)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(InvokeWithoutInteractionAsync)
    }

    // nn::Result IsAuthorized(nn::sf::Out<bool> pOut) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(IsAuthorized, (::nn::sf::Out<bool> pOut))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(IsAuthorized)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOut)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(IsAuthorized)
    }

    // nn::Result GetAuthorizationCode(nn::sf::Out<std::uint32_t> pOutActualSize, const nn::sf::OutBuffer& pOut) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetAuthorizationCode, (::nn::sf::Out<::std::uint32_t> pOutActualSize, const ::nn::sf::OutBuffer& pOut))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetAuthorizationCode)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutActualSize)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOut)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetAuthorizationCode)
    }

    // nn::Result GetIdToken(nn::sf::Out<std::uint32_t> pOutActualSize, const nn::sf::OutBuffer& pOut) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetIdToken, (::nn::sf::Out<::std::uint32_t> pOutActualSize, const ::nn::sf::OutBuffer& pOut))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetIdToken)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutActualSize)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOut)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetIdToken)
    }

    // nn::Result GetState(nn::sf::Out<nn::account::nas::State> pOut) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetState, (::nn::sf::Out<::nn::account::nas::State> pOut))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetState)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOut)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetState)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::account::nas::IAuthorizationRequest>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER((::nn::account::nas::IAuthorizationRequest))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetSessionId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetSessionId)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOut)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(InvokeWithoutInteractionAsync)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::account::detail::IAsyncContext>), pOutContext)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(InvokeWithoutInteractionAsync)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(pOutContext)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(pOutContext, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(IsAuthorized)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(IsAuthorized)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOut)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetAuthorizationCode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(pOut)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_DETAIL_APPLY_LAMBDA(_, (_.GetPointerUnsafe() != nullptr && _.GetSize() > 0), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(pOut)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetAuthorizationCode)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutActualSize),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(pOut)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetIdToken)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(pOut)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_DETAIL_APPLY_LAMBDA(_, (_.GetPointerUnsafe() != nullptr && _.GetSize() > 0), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(pOut)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetIdToken)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutActualSize),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(pOut)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetState)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(pOut)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetState)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(pOut)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetSessionId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(InvokeWithoutInteractionAsync)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(IsAuthorized)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetAuthorizationCode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetIdToken)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetState)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::account::nas::IAuthorizationRequest))

namespace nn { namespace account { namespace nas { // NOLINT(whitespace/braces)

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(IOAuthProcedureForExternalNsa, (::nn::account::http::IOAuthProcedure))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(IOAuthProcedureForExternalNsa)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetAccountId, (::nn::sf::Out<::nn::account::NetworkServiceAccountId> pOutId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetLinkedNintendoAccountId, (::nn::sf::Out<::nn::account::NintendoAccountId> pOut))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetNickname, (const ::nn::sf::OutArray<char>& nickname))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetProfileImage, (::nn::sf::Out<::std::uint32_t> pOutActualSize, const ::nn::sf::OutBuffer& pOutImage))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(IOAuthProcedureForExternalNsa)

        ::nn::Result GetAccountId(::nn::sf::Out<::nn::account::NetworkServiceAccountId> pOutId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetAccountId, (pOutId));
        }

        ::nn::Result GetLinkedNintendoAccountId(::nn::sf::Out<::nn::account::NintendoAccountId> pOut) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetLinkedNintendoAccountId, (pOut));
        }

        ::nn::Result GetNickname(const ::nn::sf::OutArray<char>& nickname) NN_NOEXCEPT
        {
            NN_SF_DETAIL_CALL_INTERNAL_ASSERT_PRE((NN_SF_DETAIL_APPLY_LAMBDA(_, (_.GetLength() == ::nn::account::NicknameBytesMax + 1), nickname)), "_.GetLength() == ::nn::account::NicknameBytesMax + 1 (where _ = nickname)")
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetNickname, (nickname));
        }

        ::nn::Result GetProfileImage(::nn::sf::Out<::std::uint32_t> pOutActualSize, const ::nn::sf::OutBuffer& pOutImage) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetProfileImage, (pOutActualSize, pOutImage));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class IOAuthProcedureForExternalNsa : public ::nn::account::http::IOAuthProcedure
    {
    public:
        nn::Result GetAccountId(nn::sf::Out<nn::account::NetworkServiceAccountId> pOutId) NN_NOEXCEPT;
        nn::Result GetLinkedNintendoAccountId(nn::sf::Out<nn::account::NintendoAccountId> pOut) NN_NOEXCEPT;
        nn::Result GetNickname(const nn::sf::OutArray<char>& nickname) NN_NOEXCEPT;
        nn::Result GetProfileImage(nn::sf::Out<std::uint32_t> pOutActualSize, const nn::sf::OutBuffer& pOutImage) NN_NOEXCEPT;
    };
#endif

}}}

#if 0

// Template for implementation users
class Impl
{
public:
    nn::Result PrepareAsync(nn::sf::Out<nn::sf::SharedPointer<nn::account::detail::IAsyncContext>> pOutContext) NN_NOEXCEPT;
    nn::Result GetRequest(nn::sf::Out<nn::account::RequestUrl> pOutRequestUrl, nn::sf::Out<nn::account::CallbackUri> pOutCallbackUri) NN_NOEXCEPT;
    nn::Result ApplyResponse(const nn::sf::InArray<char>& response) NN_NOEXCEPT;
    nn::Result ApplyResponseAsync(nn::sf::Out<nn::sf::SharedPointer<nn::account::detail::IAsyncContext>> pOutContext, const nn::sf::InArray<char>& response) NN_NOEXCEPT;
    nn::Result Suspend(nn::sf::Out<nn::account::detail::Uuid> pOutSessionId) NN_NOEXCEPT;
    nn::Result GetAccountId(nn::sf::Out<nn::account::NetworkServiceAccountId> pOutId) NN_NOEXCEPT;
    nn::Result GetLinkedNintendoAccountId(nn::sf::Out<nn::account::NintendoAccountId> pOut) NN_NOEXCEPT;
    nn::Result GetNickname(const nn::sf::OutArray<char>& nickname) NN_NOEXCEPT;
    nn::Result GetProfileImage(nn::sf::Out<std::uint32_t> pOutActualSize, const nn::sf::OutBuffer& pOutImage) NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_WITH_BASE((::nn::account::nas::IOAuthProcedureForExternalNsa), (::nn::account::http::IOAuthProcedure))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetAccountId, (::nn::sf::Out<::nn::account::NetworkServiceAccountId> pOutId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetAccountId, (pOutId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetLinkedNintendoAccountId, (::nn::sf::Out<::nn::account::NintendoAccountId> pOut))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetLinkedNintendoAccountId, (pOut));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetNickname, (const ::nn::sf::OutArray<char>& nickname))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetNickname, (nickname));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetProfileImage, (::nn::sf::Out<::std::uint32_t> pOutActualSize, const ::nn::sf::OutBuffer& pOutImage))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetProfileImage, (pOutActualSize, pOutImage));
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::account::nas::IOAuthProcedureForExternalNsa>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_WITH_BASE((::nn::account::nas::IOAuthProcedureForExternalNsa), (::nn::account::http::IOAuthProcedure))

    // nn::Result GetAccountId(nn::sf::Out<nn::account::NetworkServiceAccountId> pOutId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetAccountId)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(100)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutId, (::nn::account::NetworkServiceAccountId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pOutId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetAccountId)

    // nn::Result GetLinkedNintendoAccountId(nn::sf::Out<nn::account::NintendoAccountId> pOut) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetLinkedNintendoAccountId)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(101)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOut, (::nn::account::NintendoAccountId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pOut))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOut)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetLinkedNintendoAccountId)

    // nn::Result GetNickname(const nn::sf::OutArray<char>& nickname) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetNickname)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(102)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(nickname, 0, (const ::nn::sf::OutArray<char>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (nickname))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(nickname)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetNickname)

    // nn::Result GetProfileImage(nn::sf::Out<std::uint32_t> pOutActualSize, const nn::sf::OutBuffer& pOutImage) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetProfileImage)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(103)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(pOutImage, 0, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (pOutImage))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutActualSize, (::std::uint32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pOutActualSize))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutActualSize), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutImage)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetProfileImage)

    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::account::RequestUrl), 4096, 1)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::account::CallbackUri), 256, 1)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::account::detail::Uuid), 16, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::account::NetworkServiceAccountId), 8, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::account::NintendoAccountId), 8, 8)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::account::nas::IOAuthProcedureForExternalNsa, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_WITH_BASE((::nn::account::nas::IOAuthProcedureForExternalNsa), (::nn::account::http::IOAuthProcedure))

    // nn::Result GetAccountId(nn::sf::Out<nn::account::NetworkServiceAccountId> pOutId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetAccountId, (::nn::sf::Out<::nn::account::NetworkServiceAccountId> pOutId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetAccountId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetAccountId)
    }

    // nn::Result GetLinkedNintendoAccountId(nn::sf::Out<nn::account::NintendoAccountId> pOut) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetLinkedNintendoAccountId, (::nn::sf::Out<::nn::account::NintendoAccountId> pOut))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetLinkedNintendoAccountId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOut)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetLinkedNintendoAccountId)
    }

    // nn::Result GetNickname(const nn::sf::OutArray<char>& nickname) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetNickname, (const ::nn::sf::OutArray<char>& nickname))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetNickname)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(nickname)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetNickname)
    }

    // nn::Result GetProfileImage(nn::sf::Out<std::uint32_t> pOutActualSize, const nn::sf::OutBuffer& pOutImage) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetProfileImage, (::nn::sf::Out<::std::uint32_t> pOutActualSize, const ::nn::sf::OutBuffer& pOutImage))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetProfileImage)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutActualSize)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutImage)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetProfileImage)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::account::nas::IOAuthProcedureForExternalNsa>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_WITH_BASE((::nn::account::nas::IOAuthProcedureForExternalNsa), (::nn::account::http::IOAuthProcedure))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetAccountId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetAccountId)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetLinkedNintendoAccountId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetLinkedNintendoAccountId)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOut)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetNickname)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(nickname)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_DETAIL_APPLY_LAMBDA(_, (_.GetLength() == ::nn::account::NicknameBytesMax + 1), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(nickname)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetNickname)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(nickname)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetProfileImage)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(pOutImage)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetProfileImage)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutActualSize),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(pOutImage)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetAccountId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetLinkedNintendoAccountId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetNickname)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetProfileImage)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END_WITH_BASE

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::account::nas::IOAuthProcedureForExternalNsa))

namespace nn { namespace account { namespace nas { // NOLINT(whitespace/braces)

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(IOAuthProcedureForNintendoAccountLinkage, (::nn::account::http::IOAuthProcedure))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(IOAuthProcedureForNintendoAccountLinkage)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetRequestWithTheme, (::nn::sf::Out<::nn::account::RequestUrl> pOutRequestUrl, ::nn::sf::Out<::nn::account::CallbackUri> pOutCallbackUri, ::std::int32_t themeRaw))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(IsNetworkServiceAccountReplaced, (::nn::sf::Out<bool> pOut))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(IOAuthProcedureForNintendoAccountLinkage)

        ::nn::Result GetRequestWithTheme(::nn::sf::Out<::nn::account::RequestUrl> pOutRequestUrl, ::nn::sf::Out<::nn::account::CallbackUri> pOutCallbackUri, ::std::int32_t themeRaw) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetRequestWithTheme, (pOutRequestUrl, pOutCallbackUri, themeRaw));
        }

        ::nn::Result IsNetworkServiceAccountReplaced(::nn::sf::Out<bool> pOut) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(IsNetworkServiceAccountReplaced, (pOut));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class IOAuthProcedureForNintendoAccountLinkage : public ::nn::account::http::IOAuthProcedure
    {
    public:
        nn::Result GetRequestWithTheme(nn::sf::Out<nn::account::RequestUrl> pOutRequestUrl, nn::sf::Out<nn::account::CallbackUri> pOutCallbackUri, std::int32_t themeRaw) NN_NOEXCEPT;
        nn::Result IsNetworkServiceAccountReplaced(nn::sf::Out<bool> pOut) NN_NOEXCEPT;
    };
#endif

}}}

#if 0

// Template for implementation users
class Impl
{
public:
    nn::Result PrepareAsync(nn::sf::Out<nn::sf::SharedPointer<nn::account::detail::IAsyncContext>> pOutContext) NN_NOEXCEPT;
    nn::Result GetRequest(nn::sf::Out<nn::account::RequestUrl> pOutRequestUrl, nn::sf::Out<nn::account::CallbackUri> pOutCallbackUri) NN_NOEXCEPT;
    nn::Result ApplyResponse(const nn::sf::InArray<char>& response) NN_NOEXCEPT;
    nn::Result ApplyResponseAsync(nn::sf::Out<nn::sf::SharedPointer<nn::account::detail::IAsyncContext>> pOutContext, const nn::sf::InArray<char>& response) NN_NOEXCEPT;
    nn::Result Suspend(nn::sf::Out<nn::account::detail::Uuid> pOutSessionId) NN_NOEXCEPT;
    nn::Result GetRequestWithTheme(nn::sf::Out<nn::account::RequestUrl> pOutRequestUrl, nn::sf::Out<nn::account::CallbackUri> pOutCallbackUri, std::int32_t themeRaw) NN_NOEXCEPT;
    nn::Result IsNetworkServiceAccountReplaced(nn::sf::Out<bool> pOut) NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_WITH_BASE((::nn::account::nas::IOAuthProcedureForNintendoAccountLinkage), (::nn::account::http::IOAuthProcedure))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetRequestWithTheme, (::nn::sf::Out<::nn::account::RequestUrl> pOutRequestUrl, ::nn::sf::Out<::nn::account::CallbackUri> pOutCallbackUri, ::std::int32_t themeRaw))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetRequestWithTheme, (pOutRequestUrl, pOutCallbackUri, themeRaw));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(IsNetworkServiceAccountReplaced, (::nn::sf::Out<bool> pOut))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(IsNetworkServiceAccountReplaced, (pOut));
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::account::nas::IOAuthProcedureForNintendoAccountLinkage>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_WITH_BASE((::nn::account::nas::IOAuthProcedureForNintendoAccountLinkage), (::nn::account::http::IOAuthProcedure))

    // nn::Result GetRequestWithTheme(nn::sf::Out<nn::account::RequestUrl> pOutRequestUrl, nn::sf::Out<nn::account::CallbackUri> pOutCallbackUri, std::int32_t themeRaw) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetRequestWithTheme)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(100)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(pOutRequestUrl, 0, (::nn::sf::Out<::nn::account::RequestUrl>), 4096, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(pOutCallbackUri, 1, (::nn::sf::Out<::nn::account::CallbackUri>), 256, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(2, (pOutRequestUrl, pOutCallbackUri))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(themeRaw, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (themeRaw))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutRequestUrl), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutCallbackUri), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(themeRaw)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetRequestWithTheme)

    // nn::Result IsNetworkServiceAccountReplaced(nn::sf::Out<bool> pOut) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(IsNetworkServiceAccountReplaced)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(101)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOut, (bool), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pOut))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOut)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(IsNetworkServiceAccountReplaced)

    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::account::RequestUrl), 4096, 1)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::account::CallbackUri), 256, 1)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::account::detail::Uuid), 16, 4)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::account::nas::IOAuthProcedureForNintendoAccountLinkage, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_WITH_BASE((::nn::account::nas::IOAuthProcedureForNintendoAccountLinkage), (::nn::account::http::IOAuthProcedure))

    // nn::Result GetRequestWithTheme(nn::sf::Out<nn::account::RequestUrl> pOutRequestUrl, nn::sf::Out<nn::account::CallbackUri> pOutCallbackUri, std::int32_t themeRaw) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetRequestWithTheme, (::nn::sf::Out<::nn::account::RequestUrl> pOutRequestUrl, ::nn::sf::Out<::nn::account::CallbackUri> pOutCallbackUri, ::std::int32_t themeRaw))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetRequestWithTheme)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutRequestUrl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutCallbackUri)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(themeRaw)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetRequestWithTheme)
    }

    // nn::Result IsNetworkServiceAccountReplaced(nn::sf::Out<bool> pOut) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(IsNetworkServiceAccountReplaced, (::nn::sf::Out<bool> pOut))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(IsNetworkServiceAccountReplaced)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOut)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(IsNetworkServiceAccountReplaced)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::account::nas::IOAuthProcedureForNintendoAccountLinkage>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_WITH_BASE((::nn::account::nas::IOAuthProcedureForNintendoAccountLinkage), (::nn::account::http::IOAuthProcedure))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetRequestWithTheme)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(pOutRequestUrl)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(pOutCallbackUri)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetRequestWithTheme)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(pOutRequestUrl),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(pOutCallbackUri),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(themeRaw)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(IsNetworkServiceAccountReplaced)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(IsNetworkServiceAccountReplaced)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOut)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetRequestWithTheme)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(IsNetworkServiceAccountReplaced)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END_WITH_BASE

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::account::nas::IOAuthProcedureForNintendoAccountLinkage))
