﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/http/stream/http_WebApiAccessorBase.h>

namespace nn { namespace account { namespace http {

class SimpleDownloader
    : nn::http::stream::WebApiAccessorBase
{
    NN_DISALLOW_COPY(SimpleDownloader);

private:
    struct
    {
        void* address;
        size_t total;
        size_t used;
        std::atomic<bool> failure;
    } m_BufferInfo = {nullptr, 0u, 0u};

    static size_t WriteFunction(char* ptr, size_t unitBytes, size_t count, void* pContext) NN_NOEXCEPT;

public:
    SimpleDownloader(CURL* curlHandle, const util::Cancelable* pCancellable = nullptr) NN_NOEXCEPT;

    Result Initialize(void* buffer, size_t bufferSize) NN_NOEXCEPT;

    using WebApiAccessorBase::SetUrl;
    using WebApiAccessorBase::SetHeaders;
    using WebApiAccessorBase::SetTimeoutSeconds;

    Result Invoke(size_t* pOutSizeActual) NN_NOEXCEPT;
};

}}} // ~namespace nn::account::http
