﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/nn_SdkAssert.h>
#include <nn/os/os_SdkMutex.h>

namespace nn { namespace account { namespace detail {

template <typename MutexType, typename Tag>
struct LockGuard
{
    MutexType* base;
    explicit LockGuard(MutexType& mutex) NN_NOEXCEPT
        : base(&mutex)
    {
        base->lock();
    }
    LockGuard(LockGuard&& rhs) NN_NOEXCEPT
        : base(rhs.base)
    {
        rhs.base = nullptr;
    }
    ~LockGuard() NN_NOEXCEPT
    {
        if (base)
        {
            base->unlock();
        }
    }
    NN_EXPLICIT_OPERATOR bool() const NN_NOEXCEPT
    {
        return base != nullptr;
    }
};

}}} // ~namespace nn::account::detail
