﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

// BaaS との同期情報のキャッシュ

#include <nn/account/detail/account_CacheBase.h>
#include <nn/account/account_ResultPrivate.h>
#include <nn/account/account_Types.h>

#include <nn/nn_TimeSpan.h>

namespace nn {
namespace account {
namespace baas {

struct BaasUserResource
{
    TimeSpan timeStamp;
    Uid author;
    uint64_t lastModified;
};

class BaasUserResourceCache
    : detail::CacheBaseN<16, Uid, BaasUserResource, detail::DefaultCacheOperator<BaasUserResource>, detail::DefaultCacheResult>
{
private:
    typedef detail::CacheBaseN<16, Uid, BaasUserResource, detail::DefaultCacheOperator<BaasUserResource>, detail::DefaultCacheResult> Base;

public:
    Result Initialize(const detail::AbstractLocalStorage& storage) NN_NOEXCEPT
    {
        return Base::Initialize(storage);
    }
    void Store(const Uid& tag, const Uid& author, uint64_t lasModified) NN_NOEXCEPT;
    Result Get(BaasUserResource* pOut, const Uid& tag) const NN_NOEXCEPT;
    void Invalidate(const Uid& tag) NN_NOEXCEPT
    {
        Base::Invalidate(tag);
    }
};

} // ~namespace nn::account::baas
}
}
