﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/account/account_NintendoAccountTypes.h>
#include <nn/account/account_Types.h>
#include <nn/nn_Common.h>

namespace nn { namespace account { namespace baas {

const int BaasLoginPasswordLength = 40;

enum BaasUserState : uint32_t
{
    BaasUserState_Ok = 0x00000001,
    BaasUserState_Inconsequent = 0x80000000, //!< 本体システムとアカウントサーバーの状態に齟齬がある
    BaasUserState_Unmanaged = 0x80000001, //!< 削除済み
    BaasUserState_Banned = 0x80000002, //!< Ban されている
};

enum NintendoAccountLinkageState : uint32_t
{
    NintendoAccountLinkageState_Ok = 0x00000001,  //!< 問題なく連携している
    NintendoAccountLinkageState_Inconsequent = 0x80000000, //!< 本体システムとアカウントサーバーの状態に齟齬がある
};

enum NintendoAccountUserState : uint32_t
{
    NintendoAccountUserState_Ok = 0x00000001,
    NintendoAccountUserState_OtherButInteractionRequired = 0x00000010, //!< invalid_grant
    NintendoAccountUserState_Deleted = 0x00000011, //!< invalid_grant, error_detail=user_deleted
    NintendoAccountUserState_Banned = 0x00000012, //!< invalid_grant, error_detail=user_bannded
    NintendoAccountUserState_Suspended = 0x00000013, //!< invalid_grant, error_detail=user_suspended
    NintendoAccountUserState_Withdrawn = 0x00000014, //!< invalid_grant, error_detail=user_withdrawn
    NintendoAccountUserState_TermsAgreementRequired = 0x00000015, //!< invalid_grant, error_detail=user_terms_agreement_required
    NintendoAccountUserState_ReauthorizationRequired = 0x00000020, //!< invalid_scope, error_detail=scope_token_not_authorized
};

enum BaasUserServiceEntryRequirement : uint32_t
{
    BaasUserServiceEntryRequirement_None = 0,
    BaasUserServiceEntryRequirement_Op2CommonLicense = 1 << 0,
};

struct BaasCredential
{
    uint64_t loginId;
    char loginPassword[BaasLoginPasswordLength];
};
#define NN_ACCOUNT_BAAS_LOGIN_PASSWORD_INITIALIZER \
    { \
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, \
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, \
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, \
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, \
    }
#define NN_ACCOUNT_BAAS_CREDENTIAL_INITIALIZER \
    {0x00, NN_ACCOUNT_BAAS_LOGIN_PASSWORD_INITIALIZER}

struct BaasUserInfo
{
    NetworkServiceAccountId userId;
    BaasUserState userState;

    struct
    {
        NintendoAccountId id;
        NintendoAccountLinkageState linkState;
        NintendoAccountUserState userState;
    } nintendoAccount;
};
#define NN_ACCOUNT_BAAS_USER_INFO_INITIALIZER(userId) \
    {userId, BaasUserState_Ok, {InvalidNintendoAccountId, NintendoAccountLinkageState_Ok, NintendoAccountUserState_Ok}}

struct UserProfileBase
{
    static const size_t ExtraDataBytesForTransfer = 256;
    char nickname[NicknameBytesMax + 1];
    char extraData[ExtraDataBytesForTransfer + 1];
};

struct UserProfile
{
    static const size_t ExtraDataBytesForTransfer = UserProfileBase::ExtraDataBytesForTransfer;
    static const size_t ImageUrlBytesForTransfer = 256;
    UserProfileBase base;
    char imageUrl[ImageUrlBytesForTransfer + 1];
};

struct GuestUserProfile
{
    static const size_t ImageUrlBytesForTransfer = 256;
    NetworkServiceAccountId id;
    NintendoAccountId linkedNaId;
    char nickname[NicknameBytesMax + 1];
    char imageUrl[ImageUrlBytesForTransfer + 1];
};

}}} // ~namespace nn::account::baas
