﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/account/baas/account_BaasLoginCache.h>
#include <nn/account/baas/account_BaasTypes.h>
#include <nn/account/detail/account_Execution.h>
#include <nn/account/detail/account_LocalStorage.h>

#include <curl/curl.h>

#include <nn/nn_SdkAssert.h>

namespace nn { namespace account { namespace baas {

class BaasRegistrationDriver
{
    NN_DISALLOW_COPY(BaasRegistrationDriver);

public:
    static const size_t RequiredBufferSize;

private:
    UserAccessTokenCache& m_UserAccessTokenCache;
    UserIdTokenCache& m_UserIdTokenCache;
    const ClientAccessTokenCache& m_ClientAccessTokenCache;

public:
    BaasRegistrationDriver(
        UserAccessTokenCache& userAccessTokenCache,
        UserIdTokenCache& userIdTokenCache,
        const ClientAccessTokenCache& clientAccessTokenCache) NN_NOEXCEPT;

    Result RegisterDeviceAccount(
        NetworkServiceAccountId* pOutId,
        BaasCredential* pOutCredential,
        CURL* curlHandle, void* rawBuffer, size_t bufferSize,
        const detail::Cancellable* pCancellable = nullptr) const NN_NOEXCEPT;

    Result UnregisterDeviceAccount(
        const NetworkServiceAccountId& id,
        const BaasCredential& credential,
        CURL* curlHandle, void* rawBuffer, size_t bufferSize,
        const detail::Cancellable* pCancellable = nullptr) const NN_NOEXCEPT;
};

}}} // ~namespace nn::account::baas
