﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

/** @file
    @brief  アカウントシステムが自身を提供するプロセス向けに限定して提供する API を宣言します。 (非公開)
 */
#include <nn/nn_ApplicationId.h>
#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/os/os_Types.h>
#include <nn/sf/sf_IServiceObject.h>
#include <nn/account/account_NintendoAccountTypes.h>
#include <nn/account/account_IAccountService.sfdl.h>
#include <nn/account/account_ExternalNetworkServiceAccountInfo.h>
#include <nn/account/account_ApiForSystemServices.h>
#include <nn/account/account_Types.h>
#include <nn/account/account_TypesForSystemServices.h>
#include <nn/account/nas/account_NasTypes.h>

namespace nn { namespace account {

//! @name アカウントシステムやそのアプリケーションのデバッグのための関数
//! @{

//! @brief 外部からサービスオブジェクトを指定して Shim ライブラリを初期化します。
void InitializeWith(sf::SharedPointer<IAccountServiceForAdministrator>&& p) NN_NOEXCEPT;

/**
    @brief アカウントシステムの利用を終了します。

    @post
        - 初期化処理の実施された回数ぶん呼び出すと、初期化前の状態となります。

    @details
        アカウントシステムのクライアントライブラリの初期化回数を 1 減らします。
        初期化回数が 0 になると初期化前の状態となり、アカウントシステムを利用不可能になります。
*/
void Finalize() NN_NOEXCEPT;

//! @brief 外部からサービスオブジェクトを指定して BaasAccessTokenAccessor 機能の Shim ライブラリを初期化します。
void InitializeBaasAccessTokenAccessorWith(sf::SharedPointer<IBaasAccessTokenAccessor>&& p) NN_NOEXCEPT;

//! @brief BaasAccessTokenAccessor 機能の利用を終了します。
void FinalizeBaasAccessTokenAccessor() NN_NOEXCEPT;

// acc:u0 向け
// あとで公開
Result ListQualifiedUsers(int* pOutActualLength, Uid outUsers[], int arrayLength) NN_NOEXCEPT;

// acc:su, acc:u1 向けセーブデータサムネイル操作機能
Result StoreSaveDataThumbnailImage(const Uid& uid, const ApplicationId& applicationId, const void* imageBuffer, size_t imageBufferSize) NN_NOEXCEPT;
Result DeleteSaveDataThumbnailImage(const Uid& uid, const ApplicationId& applicationId) NN_NOEXCEPT;

// システムプログラム向け
Result CheckNetworkServiceAvailabilityAsync(AsyncContext* pOut, const SystemProgramIdentification& identification) NN_NOEXCEPT;

// ---------------------------------------------------------------------------------------------
// プログラム間での Open 状態維持のための API

// @brief PushOpenUsers() を呼ばれ、かつ PopOpenUsers() を呼ばれていないユーザーの一覧を取得します。
int ListPushedOpenUsers(Uid* outUsers, int arrayLength) NN_NOEXCEPT;

//! @}

}}  // ~namespace nn::account
