﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

/** @file
    @brief  アカウントシステムのデバッグ API を宣言します。 (非公開)
 */

#include <nn/account/account_ApiPrivate.h>
#include <nn/account/account_Types.h>

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>

namespace nn {
namespace account {

class ExternalNetworkServiceAccountRegistrar;
class ExternalNetworkServiceAccountInfo;

} // ~namespace nn::account
}

namespace nn { namespace account {

/**
    @brief (デバッグ機能) ユーザーの状態を Open 状態に変更します。

    @param[in] user 対象のユーザーを指す Uid

    @retresult
        @handleresult{
            nn::ResultSuccess,
            処理に成功しました。
        }
        @handleresult{
            nn::account::ResultUserNotExist,
            対象のユーザーアカウントが存在しません。
        }
    @endretresult

    @pre
        - static_cast<bool>(user) == true
        - user が指すユーザーが Closed 状態で存在
    @post
        - user が指すユーザーが Open 状態で存在
        - 直後の GetLastOpenedUser() は user を返す

    @details
        対象のユーザーを Closed 状態から Open 状態に変更します。
*/
Result DebugSetUserStateOpen(const Uid& user) NN_NOEXCEPT;

/**
    @brief (デバッグ機能) ユーザーの状態を Closed 状態に変更します。

    @param[in] user 対象のユーザーを指す Uid

    @retresult
        @handleresult{
            nn::ResultSuccess,
            処理に成功しました。
        }
        @handleresult{
            nn::account::ResultUserNotExist,
            対象のユーザーアカウントが存在しません。
        }
    @endretresult

    @pre
        - static_cast<bool>(user) == true
        - user が指すユーザーが Open 状態で存在
    @post
        - user が指すユーザーが Closed 状態で存在

    @details
        対象のユーザーを Open 状態から Closed 状態に変更します。
*/
Result DebugSetUserStateClose(const Uid& user) NN_NOEXCEPT;

// デバッグ用
void DebugInvalidateUserResourceCache(const Uid& user) NN_NOEXCEPT;
Result DebugIntroduceExternalNetworkServiceAccount(uint64_t* pOutInternalInfo, size_t count, ExternalNetworkServiceAccountInfo *pOutInfo, void* workBuffer, size_t workBufferSize) NN_NOEXCEPT;
Declaration DebugEnableInterprogramOpenUserRetention() NN_NOEXCEPT;

//! @}

}} // ~namespace nn::account
