﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

/** @file
    @brief BaaSのアクセストークンを利用する特殊なクライアント向けのヘッダ
    @details
        BaaS のアクセストークンを利用する特殊なクライアント向けのヘッダ。
        現時点では nn::friends のみが利用する想定。
 */

#include <nn/account/account_AsyncContext.h>
#include <nn/account/account_Types.h>
#include <nn/account/detail/account_InternalConfig.h>

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/npns/npns_Types.h>

namespace nn { namespace account {

//! @brief BaaS のアクセストークンの最大長
using detail::BaasAccessTokenSizeMax;

/**
    @brief BaaSのアクセストークンを取得するためのアクセサを初期化
    @details
        BaaSのアクセストークンを取得するためのアクセサを初期化する
        要サービス "acc:aa" へのアクセス権。
*/
void InitializeBaasAccessTokenAccessor() NN_NOEXCEPT;

/**
    @brief アクセストークンのキャッシュを確保
    @details
        指定したユーザーのもつネットワークサービスアカウントに関して、アクセストークンのキャッシュを確保する。
*/
Result EnsureBaasAccessTokenCacheAsync(AsyncContext* pOutContext, const Uid& user) NN_NOEXCEPT;

/**
    @brief アクセストークンのキャッシュを取得
    @details
        指定したユーザーのもつネットワークサービスアカウントに関して、アクセストークンのキャッシュを取得する。
*/
Result LoadBaasAccessTokenCache(size_t* pOutActualSize, char* buffer, size_t bufferSize, const Uid& user) NN_NOEXCEPT;

/**
    @brief DAの識別子を取得
    @details
        指定したユーザーのもつネットワークサービスアカウントに関して、ログインID (= Device Account ID) を取得する。
*/
Result GetBaasDeviceAccountId(uint64_t* pOut, const Uid& user) NN_NOEXCEPT;

/**
    @brief DAに通知トークンを設定する
    @details
        指定したユーザーのもつネットワークサービスアカウントに関して、Device Accountに通知トークンを登録する。
*/
Result PutBaasChannelResourceAsync(AsyncContext* pOutContext, const Uid& user, const npns::NotificationToken& nt) NN_NOEXCEPT;

/**
    @brief DAに通知トークンを設定する
    @details
        指定したユーザーのもつネットワークサービスアカウントに関して、Device Accountから通知トークンを削除する。
*/
Result DeleteBaasChannelResourceAsync(AsyncContext* pOutContext, const Uid& user) NN_NOEXCEPT;

}} // ~namespace nn::account
