﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/account/account_Api.h>
#include <nn/account/account_ApiForApplications.h>
#include <nn/account/account_Selector.h>
#include <nn/account/account_Types.h>

/**
    @namespace  nn::account
    @brief      アカウントシステムの機能を提供する名前空間です。
    @details
        この名前空間には、アカウントシステムが提供する種々の機能が含まれます。
        アカウントシステムでは以下の機能を提供します。

        ### ユーザー管理機能

        アカウントシステムは、本体システムが区別可能なユーザー識別子の発行や管理を行います。
        本体システムやアプリケーションはこのユーザー識別子を使用することで、ユーザーを区別してサービスを提供できます。

        アプリケーションがユーザーを区別してサービスを提供しているとき、本体システムがそれを検出できるよう、アカウントシステムはユーザーの状態変化を管理します。
        アカウントシステム上では、それぞれのユーザーは次の 2 つの状態のうちいずれかをとります。
        - Closed 状態
            - アプリケーションが現在、そのユーザーに対して明示的にサービスを提供していない状態。
            - 例えばゲームアプリケーション上でそのユーザーがプレイヤーとして選択されていない場合、 Closed 状態をとります。
        - Open 状態
            - アプリケーションが現在、そのユーザーに対して明示的にサービスを提供している状態。
            - 例えばゲームアプリケーション上でそのユーザーがプレイヤーとして選択されている場合、 Open 状態をとります。

        アプリケーションの起動時点で、すべてのユーザーは Closed 状態です。
        アプリケーションはユーザーの利用状況に応じて、 nn::account::OpenUser(), nn::account::CloseUser() 関数を使用してその状態を変更する必要があります。
        どういった場合にユーザーを Open 状態にする必要があるかは、各プラットフォームのガイドラインを参照してください。

        ### プロフィール管理機能

        アプリケーションがユーザーを GUI 上に表示する際の便利のために、ユーザーごとのプロフィール情報を管理します。
        アカウントシステムが管理するユーザーのプロフィール情報は次の通りです。
        - ニックネーム
            - 本体システムによって変更可能なニックネームを保持します。
            - 終端文字を除き NicknameBytesMax バイトを長さの上限として、 UTF-8 でエンコードされた任意の文字列を保持できます。
        - プロフィール画像
            - 本体システムによって作成されたプロフィール画像を保持します。
            - プロフィール画像のフォーマットに関して、詳細は nn::account::LoadProfileImage() のAPIリファレンスを参照してください。

        ### ネットワークサービスアカウント管理機能

        #### ネットワークサービスアカウント

        ネットワークサービスアカウントはフレンドシステムや NEX の機能を使用する際に必要となる、システム内部でのみ利用されるアカウントです。
        アカウントシステムはそれぞれのユーザーに対して最大で1つのネットワークサービスアカウントを紐づけて管理します。

        ネットワークサービスアカウントは本体システムによって自動的に作成され、作成の手段は本体システムに隠蔽されます。
        またユーザーに対してネットワークサービスアカウントの存在は公開されず、別の操作の副作用としてネットワークサービスアカウントが暗黙的に付与されます。
        従ってアプリケーションも、ネットワークサービスアカウントの存在をユーザーに明示する必要はありませんし、明示しないでください。
        ユーザーに対するネットワークサービスの利用方法の案内は、本体システムによって行われます。

        それぞれのユーザーがもつネットワークサービスアカウントは外部要因で置き換えられたり削除されることがあり、一定ではないことに留意してください。
        アプリケーションはユーザーのネットワークサービスアカウントが一定であることを期待せず、アプリケーション起動ごとに都度アカウントシステムから情報を取得してください。
        また、デバイスを跨いで複数のユーザーアカウントが同一のネットワークサービスアカウントと紐づく（ユーザーアカウント:ネットワークサービスアカウント=N:1）場合があります。
        同一デバイス上の複数のユーザーアカウントが同一のネットワークサービスアカウントと紐づくことはありません。

        #### ネットワークサービスアカウントが保持する情報

        ネットワークサービスアカウントは、ユーザー同士のフレンド関係やブロックリストをアプリケーション横断で保持します。
        またネットワークサービスアカウントの識別子（ネットワークサービスアカウントID）は、デバイスを跨いだユーザー識別子として機能します。

        アプリケーションがアカウントシステムから参照できるネットワークサービスアカウントに関する情報と、その使途の例は次の通りです。

        - ネットワークサービスアカウントの有無の検査
            - ユーザーに対するネットワークサービスの提供の判断に使用できます。
            - この検査は下記の操作に対する事前条件判定の一環としても行われ、違反時には専用のResult値を返却します。
        - ネットワークサービスアカウントIDの参照
            - フレンドシステムや NEX のようなネットワークサービスアカウントに基づくサービスにおいて、ユーザー識別子として使用できます。
        - ネットワークサービスアカウントの認証情報（IDトークン）の取得
            - アプリケーションがネットワークサービスアカウントサーバーと独自に通信する際に、正規に認証されたユーザーに関する通信であることを証明するために使用できます。
              ネットワークサービスアカウントサーバーによるIDトークンの検証を経ることで、ネットワークサービスアカウントのログイン処理とすることができます。
*/
namespace nn { namespace account {

}}
