﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Reflection;
using System.Runtime.InteropServices;

namespace Nintendo.ServiceFramework
{
    public class SfBuiltIn : SfValueType
    {
        public SfBuiltIn(Type target)
            : base(target)
        {
        }

        private static readonly Type[] s_BuiltInTypes = new[]
        {
            typeof(sbyte),
            typeof(byte),
            typeof(short),
            typeof(ushort),
            typeof(int),
            typeof(uint),
            typeof(long),
            typeof(ulong),
            typeof(bool),
            typeof(float),
            typeof(double),
            typeof(int_t),
            typeof(uint_t),
            typeof(char_t),
            typeof(char16_t),
            typeof(char32_t),
        };

        public static bool CanAccept(Type t)
        {
            return s_BuiltInTypes.Contains(t);
        }

        internal override IEnumerable<SfEntity> GetReferredEntities()
        {
            yield break;
        }

        internal override IEnumerable<SfEntity> GetStronglyReferredEntities()
        {
            yield break;
        }

        public override int Size
        {
            get
            {
                if (InnerType == typeof(bool))
                {
                    // bool の場合のみ sizeof(bool) と Marshal.SizeOf(typeof(bool)) が異なる
                    // ※ sizeof(bool) == 1 に対し Marshal.SizeOf(typeof(bool)) == 4
                    return 1;
                }
                else
                {
                    // bool 以外の場合には sizeof(T) と Marshal.SizeOf(typeof(T)) なので、
                    // 実装手段として Marshal.SizeOf を用いる
                    return Marshal.SizeOf(InnerType);
                }
            }
        }

        public override int Alignment
        {
            get
            {
                // 現状 BuiltIn で扱っている型はすべて、Size == Alignment であるため Size の実装を流用
                return Size;
            }
        }
    }
}
