﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Nintendo.ServiceFramework;
using Nintendo.ServiceFramework.CppCode;
using Nintendo.ServiceFramework.Hipc;

// このファイルのシンボルは C++ と名前を合わせるため、先頭を小文字にしている部分がある。
// よって StyleCop の対象外としている。

namespace nn
{
    /// <summary>
    /// nn::Result に対応する型
    /// </summary>
    public class Result
    {
        public int InnerValue { get; set; }
    }

    [CppRefPath(@"<nn/nn_BitTypes.h>")]
    [CppFullName(@"nn::Bit8")]
    public struct Bit8
    {
        public byte value;
    }

    [CppRefPath(@"<nn/nn_BitTypes.h>")]
    [CppFullName(@"nn::Bit16")]
    public struct Bit16
    {
        public ushort value;
    }

    [CppRefPath(@"<nn/nn_BitTypes.h>")]
    [CppFullName(@"nn::Bit32")]
    public struct Bit32
    {
        public uint value;
    }

    [CppRefPath(@"<nn/nn_BitTypes.h>")]
    [CppFullName(@"nn::Bit64")]
    public struct Bit64
    {
        public ulong value;
    }
}

namespace nn.sf
{
    /// <summary>
    /// サービスオブジェクト共通インターフェイス
    /// </summary>
    public interface IServiceObject
    {
        void AddReference();
        void Release();
    }

    /// <summary>
    /// 出力パラメータであることを表すための型
    /// </summary>
    /// <typeparam name="T">出力する型</typeparam>
    public class Out<T>
    {
        public T Value { get; set; }
    }

    /// <summary>
    /// 入力バッファを表す型
    /// </summary>
    /// <remarks>
    /// メンバなどは暫定
    /// </remarks>
    [BufferTransferInternalDirection(BufferTransferInternalDirection.In)]
    [BufferTransferMode(BufferTransferMode.MapAlias)]
    public class InBuffer
    {
        public int Address { get; set; }
        public int Size { get; set; }
    }

    /// <summary>
    /// 出力バッファを表す型
    /// </summary>
    /// <remarks>
    /// メンバなどは暫定
    /// </remarks>
    [BufferTransferInternalDirection(BufferTransferInternalDirection.Out)]
    [BufferTransferMode(BufferTransferMode.MapAlias)]
    public class OutBuffer
    {
        public int Address { get; set; }
        public int Size { get; set; }
    }

    /// <summary>
    /// native ハンドルを表すための型
    /// </summary>
    public class NativeHandle
    {
    }

    /// <summary>
    /// 可変長入力配列を表す型
    /// </summary>
    /// <typeparam name="T">配列の要素型</typeparam>
    [BufferTransferInternalDirection(BufferTransferInternalDirection.In)]
    [BufferTransferMode(BufferTransferMode.PointerCopy)]
    public class InArray<T>
    {
    }

    /// <summary>
    /// 可変長出力配列を表す型
    /// </summary>
    /// <typeparam name="T">配列の要素型</typeparam>
    [BufferTransferInternalDirection(BufferTransferInternalDirection.Out)]
    [BufferTransferMode(BufferTransferMode.PointerCopy)]
    public class OutArray<T>
    {
    }
}
