﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Nintendo.ServiceFramework.CppCode
{
    public class NnResultCppCodeEmitter : EntityCppCodeEmitterBase<SfNnResult>
    {
        internal NnResultCppCodeEmitter(SfNnResult entity)
            : base(entity)
        {
        }

        private static readonly string[] CommonIncludes = new[]
        {
            @"<nn/nn_Result.h>",
        };

        public override string GetCppTypeString(bool friendly)
        {
            return friendly ? @"nn::Result" : @"::nn::Result";
        }

        public override string GetStructPlacedString(string variableName, bool friendly)
        {
            return GetParameterString(variableName, InOutType.In, friendly);
        }

        public override IEnumerable<string> GetExternalIncludes()
        {
            return CommonIncludes;
        }

        public override void EmitForwardDeclarationCode(RawCppCodeGenerator rawGen)
        {
            // nop
        }

        public override void EmitDefinitionCode(RawCppCodeGenerator rawGen)
        {
            // nop
        }
    }
}
