﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Nintendo.ServiceFramework.CppCode
{
    public class NativeHandleCppCodeEmitter : EntityCppCodeEmitterBase<SfNativeHandle>
    {
        internal NativeHandleCppCodeEmitter(SfNativeHandle entity)
            : base(entity)
        {
        }

        private static readonly string[] CommonIncludes = new[]
        {
            @"<nn/sf/sf_NativeHandle.h>",
        };

        public override string GetForwardString(string variableName, InOutType inOutType, bool friendly)
        {
            if (inOutType == InOutType.In)
            {
                return string.Format(@"{0}std::move({1})", friendly ? string.Empty : "::", variableName);
            }
            else
            {
                return base.GetForwardString(variableName, inOutType, friendly);
            }
        }

        public override string GetCppTypeString(bool friendly)
        {
            return friendly ? @"nn::sf::NativeHandle" : @"::nn::sf::NativeHandle";
        }

        public override string GetParameterString(string variableName, InOutType inOutType, bool friendly)
        {
            switch (inOutType)
            {
                case InOutType.In:
                    {
                        return string.Format(@"{0}&& {1}", GetCppTypeString(friendly), variableName);
                    }
                default:
                    {
                        return base.GetParameterString(variableName, inOutType, friendly);
                    }
            }
        }

        public override string GetStructPlacedString(string variableName, bool friendly)
        {
            return base.GetParameterString(variableName, InOutType.In, friendly);
        }

        public override IEnumerable<string> GetExternalIncludes()
        {
            return CommonIncludes;
        }

        public override void EmitForwardDeclarationCode(RawCppCodeGenerator rawGen)
        {
            // nop
        }

        public override void EmitDefinitionCode(RawCppCodeGenerator rawGen)
        {
            // nop
        }
    }
}
