﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Nintendo.ServiceFramework
{
    public class SizeAndAlignment
    {
        public int Size { get; set; }
        public int Alignment { get; set; }
    }

    public static class BinaryFormatUtility
    {
        private static int RoundUp(int n, int alignment)
        {
            var padding = n % alignment;
            return padding == 0 ? n : n + alignment - padding;
        }

        public static SizeAndAlignment GetSizeAndAlignment(IEnumerable<SizeAndAlignment> fields)
        {
            var size = 0;
            var alignment = 1;
            foreach (var f in fields)
            {
                size = RoundUp(size, f.Alignment) + f.Size;
                alignment = Math.Max(alignment, f.Alignment);
                if (!(alignment % f.Alignment == 0))
                {
                    throw new WrongImplementationException();
                }
            }
            size = RoundUp(size, alignment);
            return new SizeAndAlignment { Size = size, Alignment = alignment };
        }

        public static Tuple<SizeAndAlignment, IEnumerable<int>> GetSizeAndAlignmentAndOffsets(IEnumerable<SizeAndAlignment> fields)
        {
            var offset = 0;
            var alignment = 1;
            var offsets = new List<int>();
            foreach (var f in fields)
            {
                offset = RoundUp(offset, f.Alignment);
                offsets.Add(offset);
                offset += f.Size;
                alignment = Math.Max(alignment, f.Alignment);
                if (!(alignment % f.Alignment == 0))
                {
                    throw new WrongImplementationException();
                }
            }
            offset = RoundUp(offset, alignment);
            return Tuple.Create(new SizeAndAlignment { Size = offset, Alignment = alignment }, offsets.AsEnumerable());
        }
    }
}
