﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.IO;
using System.Net;
using System.Text.RegularExpressions;
using System.Threading.Tasks.Dataflow;
using Nintendo.Foundation.IO;

namespace Nintendo.UpdateHostBridge
{
    public class ListArgument
    {
    }

    public class UpdateArgument
    {
        public string Target { get; set; }
        public FileInfo FirmwareImagePath { get; set; }
        public bool IsWaitReboot { get; set; }
        public bool IsVerbose { get; set; }
        public bool IsRecovery { get; set; }

        public UpdateArgument(UpdateArgumentRaw rawArgs)
        {
            Target = rawArgs.Target;
            if (rawArgs.FirmwareImagePath != null)
            {
                FirmwareImagePath = new FileInfo(rawArgs.FirmwareImagePath);
            }
            IsWaitReboot = rawArgs.WaitBootFlag;
            IsVerbose = rawArgs.Verbose;
            IsRecovery = rawArgs.Recovery;
        }
    }

    public class UpdateArgumentRaw
    {
        [CommandLineOption("target", IsRequired = true,
            Description = "Specify the target.")]
        public string Target { get; set; }

        [CommandLineOption("image",
            Description = "Specify the HostBridge Firmware image.")]
        public string FirmwareImagePath { get; set; }

        [CommandLineOption("waitboot", DefaultValue = false,
            Description = "Wait until the target complete rebooting.")]
        public bool WaitBootFlag { get; set; }

        [CommandLineOption('v', "verbose",
            Description = "Output trace logs.")]
        public bool Verbose { get; set; }

        [CommandLineOption("recovery",  Description = "Update recovery firmware.", IsHidden = true)]
        public bool Recovery { get; set; }
    }

    public class UpdateIsRequired
    {
        [CommandLineOption("target", IsRequired = true,
            Description = "Specify the target.")]
        public string Target { get; set; }
    }

    public class NnRunCommandArgumentRaw
    {
        [CommandLineSubCommand("list", Description = "List targets.")]
        public ListArgument List { get; set; }

        [CommandLineSubCommand("update", Description = "Update a target.")]
        public UpdateArgumentRaw Update { get; set; }

        [CommandLineSubCommand("required", Description = "Confirm recovery update is required or not.")]
        public UpdateIsRequired IsRecoveryUpdateRequired { get; set; }
    }
}
