﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Text;
using System.IO;

namespace Nintendo.InitializeSdev
{
    public class SaveLogFile
    {
        const string BaseLogFilePath = @"Nintendo\InitializeSdevWin\Last.log";

        public static bool Write(string logString)
        {
            SaveLogFileCore logFile = new SaveLogFileCore(BaseLogFilePath);
            return logFile.Write(logString);
        }

        public static bool DeleteLogFile()
        {
            SaveLogFileCore logFile = new SaveLogFileCore(BaseLogFilePath);
            return logFile.Delete();
        }
    }

    public class SaveLogFileCore : IDisposable
    {
        private string m_BaseLogFilePath = null;
        private string m_LogFilePath = null;

        private SaveLogFileCore()
        {
        }

        public SaveLogFileCore(string baseLogFilePath)
        {
            m_BaseLogFilePath = baseLogFilePath;
            m_LogFilePath = GetLogFilePath();
        }

        public void Close()
        {
        }

        public void Dispose()
        {
        }

        public bool Write(string logString)
        {
            if(m_LogFilePath == null || File.Exists(m_LogFilePath))
            {
                System.Diagnostics.Trace.WriteLine("[ERROR] log file is not set or file exists.");
                return false;
            }
            string directoryPath = Path.GetDirectoryName(m_LogFilePath);
            try
            {
                if (!Directory.Exists(directoryPath))
                {
                    Directory.CreateDirectory(directoryPath);
                }
                StreamWriter sw = new StreamWriter(m_LogFilePath, false, Encoding.GetEncoding("utf-8"));
                sw.Write(logString);
                sw.Close();
            }
            catch (UnauthorizedAccessException)
            {
                // ディレクトリアクセス権限がない場合に発生する例外
                return false;
            }
            return true;
        }

        private string GetLogFilePath()
        {
            // %LOCALAPPDATA%\..\LocalLow
            string path = Environment.ExpandEnvironmentVariables(@"%LOCALAPPDATA%\..\LocalLow");
            path = Path.GetFullPath(Path.Combine(path, m_BaseLogFilePath));
            return path;
        }

        public bool Delete()
        {
            string logFilePath = GetLogFilePath();
            if(File.Exists(logFilePath))
            {
                try
                {
                    File.Delete(logFilePath);
                }
                catch(UnauthorizedAccessException)
                {
                    // ディレクトリアクセス権限がない場合に発生する例外
                    return false;
                }
            }
            return true;
        }
    }
}
