﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using Nintendo.ControlTarget;

namespace Nintendo.InitializeSdev
{

    public static class MenuCommandHandler
    {
        public static ExitStatus BlinkLEDs(string ipAddress)
        {
            ExitStatus eStatus = BlinkLed.Execute(ipAddress);
            if (eStatus != ExitStatus.Success)
            {
                MessageBox.Show("Blink LEDs failed.", "Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
            return eStatus;
        }

        public static ExitStatus WriteSerialNumberToHostBridge(string macAddress)
        {
            using (var accessor = new TargetManagerAccessor())
            {
                accessor.SetStartTrayIcon(true);
                accessor.SetStartForInitialize(true);
                accessor.EnsureStart();
            }

            if (TargetSpecifier.GetTargetSerialFromMac(macAddress) != "Unknown")
            {
                MessageBox.Show("Serial Number is already witten.", "Skipped", MessageBoxButtons.OK, MessageBoxIcon.Information);
                return ExitStatus.Success;
            }

#if false
            if (RestartTarget(ref handle, targetKeyString, targetManagerDirectory) != ExitStatus.Success)
            {
                LOG.LogLine(LOG_LEVEL.LOG_ERROR, "Reboot target failed.");
                return ExitStatus.Failure;
            }
#endif

            string targetIp = TargetSpecifier.GetTargetIpFromMac(macAddress);
            if (targetIp == null)
            {
                MessageBox.Show("Failed to find target.", "Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
                // LOG.LogLine(LOG_LEVEL.LOG_ERROR, "Get IP address failed.");
                return ExitStatus.Failure;
            }

            // Call WriteSerialNumber
            List<string> args1 = new List<string>() { "--target", targetIp };
            args1.Add("--write-name");
            // args1.Add("--verbose");
            List<string> argsList = new List<string>();
            argsList.AddRange(args1);

            // ProcessAccessor.DumpProcessArgumentList("WriteSerialNumber", argsList);

            int retVar = Nintendo.WriteSerialNumber.CommandInterface.Main(argsList.ToArray());

            if (retVar != 0)
            {
                MessageBox.Show("Write serial number failed.", "Failure", MessageBoxButtons.OK, MessageBoxIcon.Error);
                return ExitStatus.Failure;
            }

            ExitStatus eStatus = RebootTarget(targetIp);
            if (eStatus != ExitStatus.Success)
            {
                MessageBox.Show("Reboot SDEV failed. Please reboot manually.", "Waring", MessageBoxButtons.OK, MessageBoxIcon.Warning);
                return eStatus;
            }

            MessageBox.Show("Write serial number succeeded.", "Success");
            return ExitStatus.Success;
        }

        private static ExitStatus RebootTarget(string targetIp)
        {
            FirmwareResourceSpecifier firmwareResource = new FirmwareResourceSpecifier();
            if (firmwareResource.SetVersion(FirmwareResourceSpecifier.GetUpToDateVersion()) == false)
            {
                return ExitStatus.Failure;
            }
            string targetManagerPath = firmwareResource.GetFileNameOfFirm(FirmwareType.Host_TargetManager);
            if (FirmwareResourceSpecifier.CheckFilePath(nameof(targetManagerPath), targetManagerPath) == false)
            {
                return ExitStatus.Failure;
            }
            TargetManagerAccess.RebootTarget(targetIp, targetManagerPath, false);
            System.Threading.Thread.Sleep(5000);

            return ExitStatus.Success;
        }
    }
}
