﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using System.IO;
//using Nintendo.Foundation.IO;
using Nintendo.InitializeSdev;

namespace InitializeSdevWinLibrary
{
    public partial class MainForm : Form
    {
        private InitialProgressDialog initialProcessDialog = null;
        private string[] EnumerateIps, EnumerateNames, EnumerateMacs, EnumerateSerials;
        private int[] EnumeratePorts;
        private List<string> FirmwareVersionList;
        private List<string> FirmwareRevisionList;
        private bool HasOceanFirmware = false;
        private ListViewSort LvSorter;

        public MainForm()
        {
            InitializeComponent();
        }

        private void ファイルFToolStripMenuItem_Click(object sender, EventArgs e)
        {

        }

        private void button2_Click(object sender, EventArgs e)
        {
            DoInitialize();
        }

        private void DoInitialize()
        {
            if (this.SdevListView.SelectedItems.Count <= 0)
            {
                MessageBox.Show("SDEV actual equipment is not selected.\nPlease select SDEV.", "SDEV select", MessageBoxButtons.OK, MessageBoxIcon.Error);
                return;
            }
            if (this.firmwareVersionSelectComboBox.SelectedIndex < 0)
            {
                MessageBox.Show("Firmware version field is not selected.\nPlease select .", "SDEV select", MessageBoxButtons.OK, MessageBoxIcon.Error);
                return;
            }

            LogForm f = new LogForm();
            f.SdevMacAddress = this.SdevListView.SelectedItems[0].SubItems[0].Text;
            if (this.firmwareVersionSelectComboBox.SelectedIndex == 0)
            {
                f.FirmwareVersion = null;
            }
            else
            {
                f.FirmwareVersion = this.firmwareVersionSelectComboBox.SelectedItem.ToString();
            }
            f.ShowDialog(this);
            f.Dispose();
        }

        private void 終了XToolStripMenuItem_Click(object sender, EventArgs e)
        {
            this.Close();
        }

        private void バージョン情報VToolStripMenuItem_Click(object sender, EventArgs e)
        {
            // MessageBox.Show(Application.ProductName + ' ' + Application.ProductVersion);

            // var assm = System.Reflection.Assembly.GetExecutingAssembly();
            var assm = System.Reflection.Assembly.GetEntryAssembly();
            var name = assm.GetName();
            MessageBox.Show(name.Name + ' ' + name.Version);
        }

        private void ネットワーク接続の変更NToolStripMenuItem_Click(object sender, EventArgs e)
        {
            System.Diagnostics.Process.Start("ncpa.cpl");
        }

        private void MainForm_Load(object sender, EventArgs e)
        {
            StartInitializeButton.Enabled = false;
            SaveLogFile.DeleteLogFile();
            UpdateSdevListFirst();

            this.Enabled = false;  // MEMO: disable for InitialProgressDialog
            BackgroundToolInitializeWorker.RunWorkerAsync();
        }

        private void InitializeSdevListHeader()
        {
            this.SdevListView.FullRowSelect = true;
            this.SdevListView.GridLines = true;

            ColumnHeader columnName = new ColumnHeader();
            ColumnHeader columnIp = new ColumnHeader();
            ColumnHeader columnPort = new ColumnHeader();
            ColumnHeader columnMac = new ColumnHeader();
            ColumnHeader columnSerial = new ColumnHeader();
            // MEMO: width infomation by fontsize of SdevListView
            //   font  form listview MAC  IP Port Name Serial
            //      9   640      518 120 105   45  120    105
            //     10   720      598 135 120   50  140    120
            columnMac.Text = "MAC";
            columnMac.Width = 120;
            columnIp.Text = "IP";
            columnIp.Width = 105;
            columnPort.Text = "Port";
            columnPort.Width = 45;
            columnName.Text = "Name";
            columnName.Width = 120;
            columnSerial.Text = "Serial";
            columnSerial.Width = 105;
            ColumnHeader[] headerValue = { columnMac, columnIp, columnPort, columnName, columnSerial };
            this.SdevListView.Columns.AddRange(headerValue);

            LvSorter = new ListViewSort();
            LvSorter.ColumnModes = new ListViewSort.CompareMode[] { ListViewSort.CompareMode.Compare_String,
                                                                    ListViewSort.CompareMode.Compare_String,
                                                                    ListViewSort.CompareMode.Compare_String,
                                                                    ListViewSort.CompareMode.Compare_String,
                                                                    ListViewSort.CompareMode.Compare_String };
            this.SdevListView.ListViewItemSorter = LvSorter;
        }

        private bool UpdateSdevListFirst()
        {
            this.SdevListView.Clear();
            InitializeSdevListHeader();
            this.SdevListView.Update();

            return true;
        }

        private bool UpdateSdevListCore()
        {
            EnumerateIps = new string[0];
            EnumeratePorts = new int[0];
            EnumerateNames = new string[0];
            EnumerateMacs = new string[0];
            EnumerateSerials = new string[0];
            TargetSpecifier.EnumerateTargets(out EnumerateIps, out EnumeratePorts, out EnumerateNames, out EnumerateMacs, out EnumerateSerials);

            return true;
        }

        private bool UpdateSdevListLast()
        {
            if (EnumerateIps == null)
            {
                return false;
            }

            for (int i = 0; i < EnumerateIps.Length; i++)
            {
                string[] sItems = { EnumerateMacs[i].ToUpper(), EnumerateIps[i], EnumeratePorts[i].ToString(), EnumerateNames[i], EnumerateSerials[i] };
                ListViewItem lItem = new ListViewItem(sItems);
                lItem.Tag = i;
                this.SdevListView.Items.Add(lItem);
            }
            // for debug of SdevListView's column width
            // string[] testitem = { "AA:AA:AA:AA:AA:AA", "255.255.255.255", "11111", "AA-AA-AA-AA-AA-AA", "XAWF0111100000X" };
            // this.SdevListView.Items.Add(new ListViewItem(testitem));
            return true;
        }

        private bool UpdateSdevList()
        {
            if (!UpdateSdevListFirst())
            {
                return false;
            }

            if (!UpdateSdevListCore())
            {
                return false;
            }

            if (!UpdateSdevListLast())
            {
                return false;
            }

            return true;
        }

        private void GetVersionListFirst()
        {
            FirmwareVersionList = new List<string>();
            FirmwareRevisionList = new List<string>();
            bool bRet = FirmwareResourceSpecifier.EnumerateAllVersions(ref FirmwareVersionList);
            FirmwareResourceSpecifier.EnumerateAllRevisions(ref FirmwareRevisionList);
            HasOceanFirmware = FirmwareResourceSpecifier.ContainsOceanFirmware();
        }

        private void GetVersionListLast()
        {
            this.firmwareVersionSelectComboBox.Items.Clear();
            int index = 0;
            foreach (string versionStr in FirmwareVersionList)
            {
                string revisionStr = FirmwareRevisionList[index];
                if(revisionStr != string.Empty)
                {
                    this.firmwareVersionSelectComboBox.Items.Add(string.Format("{0}  (rev:{1})", versionStr, revisionStr));
                }
                else
                {
                    this.firmwareVersionSelectComboBox.Items.Add(versionStr);
                }

                if (HasOceanFirmware)
                {
                    if (FirmwareResourceAccessor.GetInstance().CheckOceanVersion(versionStr))
                    {
                        firmwareVersionSelectComboBox.SelectedIndex = index;
                    }
                }
                else
                {
                    firmwareVersionSelectComboBox.SelectedIndex = 0;
                }
                index++;
            }
        }

        private void GetVersionList()
        {
            GetVersionListFirst();
            GetVersionListLast();
        }

        private void ReScanButton_Click(object sender, EventArgs e)
        {
            UpdateSdevList();
        }

        private void BackgroundToolInitializeWorker_DoWork(object sender, DoWorkEventArgs e)
        {
            initialProcessDialog = new InitialProgressDialog();
            initialProcessDialog.Show(this);

            {
                GetVersionListFirst();

                if (initialProcessDialog.Canceled) goto quit;

                ProcessAccessor.StopTargetManager();

                if (initialProcessDialog.Canceled) goto quit;

                UpdateSdevListCore();
            }

        quit:
            initialProcessDialog.Close();
        }

        private void BackgroundToolInitializeWorker_ProgressChanged(object sender, ProgressChangedEventArgs e)
        {

        }

        private void BackgroundToolInitializeWorker_RunWorkerCompleted(object sender, RunWorkerCompletedEventArgs e)
        {
            GetVersionListLast();
            UpdateSdevListLast();
            // MEMO: disable for InitialProgressDialog
            ReScanButton.Enabled = true;
            this.Enabled = true;
            this.TopMost = true;
            this.TopMost = false;
            this.Activate();
        }

        private void SdevListView_SelectedIndexChanged(object sender, EventArgs e)
        {
            StartInitializeButton.Enabled = CanStartInitialize() ? true : false;
            ListViewContextMenuStrip.Enabled = CanStartInitialize() ? true : false;
        }

        private bool CanStartInitialize()
        {
            return SdevListView.SelectedItems.Count > 0 && firmwareVersionSelectComboBox.SelectedIndex >= 0;
        }

        private void firmwareVersionSelectComboBox_SelectedIndexChanged(object sender, EventArgs e)
        {
            StartInitializeButton.Enabled = CanStartInitialize() ? true : false;
        }

        private void viewhelpToolStripMenuItem_Click(object sender, EventArgs e)
        {
            string itemPath = ConstData.GetInitializeSdevDocumentUrl();
            if (File.Exists(itemPath))
            {
                System.Diagnostics.Process.Start(itemPath);
            }
            else
            {
                MessageBox.Show("Document page not found.\nPlease install Document Package.", "Error", MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
            }
        }

        private void SdevListView_ColumnClick(object sender, ColumnClickEventArgs e)
        {
            LvSorter.Column = e.Column;
            this.SdevListView.Sort();
        }

        private void startinitializationToolStripMenuItem_Click(object sender, EventArgs e)
        {
            DoInitialize();
        }

        private void blinkLEDsToolStripMenuItem_Click(object sender, EventArgs e)
        {
            string selectIP = this.SdevListView.SelectedItems[0].SubItems[1].Text;
            MenuCommandHandler.BlinkLEDs(selectIP);
        }

        private void writeSerialNumberToHostBridgeToolStripMenuItem_Click(object sender, EventArgs e)
        {
            string selectMacAddress = this.SdevListView.SelectedItems[0].SubItems[0].Text;
            MenuCommandHandler.WriteSerialNumberToHostBridge(selectMacAddress);
        }
    }
}
