﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Nintendo.InitializeEdev
{
    public class ConstData
    {
        private const string EdevErrorInformation1 = "Please check following points,\r\n          1, The serial number is identical.\r\n          2, Battery is charged well.\r\n" +
                                                    "          3, Re-connect USB cable and re-power on.\r\n          4, Try to enter safe mode manually and retry.\r\n" +
                                                    "        The infomation is written in ";
        private const string EdevErrorInformation2 = " .";
        private const string EdevErrorDocumentUrlBase = @"\Documents\Package\contents\Pages\Page_159244488.html";
        private const string InitializeEdevDocumentUrlBase = @"\Documents\Package\contents\Pages\Page_124929523.html";

        public static string GetEdevErrorInfomationString()
        {
            string sdkRootPath = Nintendo.ControlTarget.PathUtility.FindSigloRoot();
            return EdevErrorInformation1 + sdkRootPath + EdevErrorDocumentUrlBase + EdevErrorInformation2;
        }

        public static string GetErrorDocumentUrl()
        {
            return Nintendo.ControlTarget.PathUtility.FindSigloRoot() + EdevErrorDocumentUrlBase;
        }

        public static string GetInitializeEdevDocumentUrl()
        {
            return Nintendo.ControlTarget.PathUtility.FindSigloRoot() + InitializeEdevDocumentUrlBase;
        }
    }
}
