﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Diagnostics;
using Nintendo.Foundation.IO;
using System.Threading;
using System.Globalization;

namespace Nintendo.ControlTarget
{
    public class ControlTargetPrivateArgument : ControlTargetArgument
    {
        [CommandLineSubCommand("force-recovery", Description = "Transition force recovery mode.")]
        public ForceRecoveryCommand ForceRecoveryCommand { get; set; }

        [CommandLineSubCommand("force-recovery-hostbridge", Description = "Transition force recovery mode by hostbridge.")]
        public ForceRecoveryHostBridgeCommand ForceRecoverHostBridgeCommand { get; set; }

        [CommandLineSubCommand("power-on-phidgets", Description = "Power on with Phidgets")]
        public PhidgetsPowerOnCommand PhidgetsPowerOnCommand { get; set; }

        [CommandLineSubCommand("power-off-phidgets", Description = "Power off with Phidgets")]
        public PhidgetsPowerOffCommand PhidgetsPowerOffCommand { get; set; }

        [CommandLineSubCommand("safemode-phidgets", Description = "Boot safemode with Phidgets")]
        public PhidgetsSafeModeCommand PhidgetsSafeModeCommand { get; set; }

        [CommandLineSubCommand("get-hostbridge-version", Description = "Get HostBridge version.")]
        public GetHostBridgeVersionCommand GetHostBridgeVersionCommand { get; set; }

        [CommandLineSubCommand("boot-safemode", Description = "Boot safemode.")]
        public BootSafeModeCommand BootSafeModeCommand { get; set; }

        [CommandLineSubCommand("boot-safemode-for-old-versions", Description = "Boot safemode for old versions.")]
        public BootSafeModeForOldVersionsCommand BootSafeModeForAnyVersionsCommand { get; set; }

        [CommandLineSubCommand("get-target-information", Description = "Get target information")]
        public GetTargetInformationCommand GetTargetInformationCommand { get; set; }

        [CommandLineSubCommand("list-service-all", Description = "List htcs services including system services.")]
        public ListServiceAllCommandArgument ListServicePrivateCommand { get; set; }

        [CommandLineSubCommand("press-power-button-for-sc7", Description = "Press power button for SC7 target power state.")]
        public PressPowerButtonForSc7Command PressPowerButtonForSc7Command { get; set; }

        [CommandLineSubCommand("emulate-thermal-sensor", Description = "Emulate thermal status.")]
        public EmulateThermalCommand EmulateThermalCommand { get; set; }

        [CommandLineSubCommand("save-screen-shot", Description = "Save screen shot.")]
        public SaveScreenShotCommand SaveScreenShotCommand { get; set; }

        [CommandLineSubCommand("set-battery-level-for-sc7", Description = "Set a battery level for SC7 target power state.")]
        public SetBatteryLevelForSc7Command SetBatteryLevelForSc7Command { get; set; }

        [CommandLineSubCommand("set-usb-connection-debugboard", Description = "Set USB connection for all connected devices with debugboard")]
        public DebugBoardSetUsbConnectionCommand DebugBoardSetUsbConnectionCommand { get; set; }

        [CommandLineSubCommand("press-power-button-debugboard", Description = "Press powerbutton for all connected devices with debugboard")]
        public DebugBoardPressPowerButtonCommand DebugBoardPressPowerButtonCommand { get; set; }

        [CommandLineSubCommand("reset-debugboard", Description = "Make all connected devices resetted with debugboard")]
        public DebugBoardResetCommand DebugBoardResetCommand { get; set; }

        [CommandLineSubCommand("force-recovery-debugboard", Description = "Enter force recovery mode for all connected devices with debugboard")]
        public DebugBoardForceRecoveryCommand DebugBoardForceRecoveryCommand { get; set; }
    }

    public class Program
    {
        public static void Main(string[] args)
        {
            Thread.CurrentThread.CurrentUICulture = new CultureInfo("en", true);

            try
            {
                ControlTargetPrivateArgument parsed;
                var parser = new Nintendo.Foundation.IO.CommandLineParser();

                if (false == parser.ParseArgs<ControlTargetPrivateArgument>(args, out parsed))
                {
                    System.Environment.Exit(1);
                }

                CommandCommon.FindActivatedSubCommand(parsed).Run();
            }
            catch (Exception exception)
            {
                PrintException(exception);
                System.Environment.Exit(1);
            }
        }

        public static void PrintException(Exception exception)
        {
            Console.Error.WriteLine("[ERROR] {0}", exception.Message);
            Console.Error.Write("StackTrace: {0}", exception.StackTrace);
        }
    }
}
