﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Nintendo.Foundation.IO;

namespace Nintendo.ControlTarget
{
    public class PhidgetsPowerOffCommand : CommandCommon
    {
        [CommandLineOption("phidgets-serial",
        Description = "Set Phidget SerialNumber.",
        DefaultValue = 0)]
        public int SerialNumber { get; set; }

        public override void Run()
        {
            if (Verbose)
            {
                PhidgetUtility.EnableVerboseLog();
            }

            if (SerialNumber == 0)
            {
                PhidgetUtility.SendSignals(e =>
                {
                    PhidgetUtility.EnsureOutput(e, 2, false);   // Power を離す
                    Task.Delay(500).Wait();
                    PhidgetUtility.EnsureOutput(e, 2, true);    // Power を押す
                    Task.Delay(14000).Wait();
                    PhidgetUtility.EnsureOutput(e, 2, false);   // Power を離す
                });
            }
            else
            {
                PhidgetUtility.SendSignals(e =>
                {
                    PhidgetUtility.EnsureOutput(e, 2, false);   // Power を離す
                    Task.Delay(500).Wait();
                    PhidgetUtility.EnsureOutput(e, 2, true);    // Power を押す
                    Task.Delay(14000).Wait();
                    PhidgetUtility.EnsureOutput(e, 2, false);   // Power を離す
                },
                SerialNumber, TimeSpan.FromMilliseconds(500));
            }
        }
    }
}
