﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Nintendo.Foundation.IO;
using Nintendo.ManuHostTools.UsbLibrary;

namespace Nintendo.ControlTarget
{
    public class ForceRecoveryCommand : CommandCommon
    {
        [CommandLineOption("phidgets-serial",
        Description = "Set Phidget SerialNumber.",
        DefaultValue = 0)]
        public int SerialNumber { get; set; }

        [CommandLineOption("confirm-until-seconds",
        Description = "confirm enter forced-recovery mode until specified seconds",
        DefaultValue = -1)]
        public int WaitSeconds { get; set; }

        public override void Run()
        {
            if (Verbose)
            {
                PhidgetUtility.EnableVerboseLog();
            }

            if (SerialNumber == 0)
            {
                PhidgetUtility.SendSignals(e =>
                {
                    PhidgetUtility.EnsureOutput(e, 2, false);   // Power を離す
                    Task.Delay(500).Wait();
                    PhidgetUtility.EnsureOutput(e, 0, false);   // VolUp を離す
                    Task.Delay(500).Wait();
                    PhidgetUtility.EnsureOutput(e, 0, true);    // VolUp を押す
                    Task.Delay(500).Wait();
                    PhidgetUtility.EnsureOutput(e, 2, true);    // Power を押す
                    Task.Delay(500).Wait();
                    PhidgetUtility.EnsureOutput(e, 2, false);   // Power を離す
                    Task.Delay(500).Wait();
                    PhidgetUtility.EnsureOutput(e, 0, false);   // VolUp を離す
                    Task.Delay(500).Wait();
                });
            }
            else
            {
                PhidgetUtility.SendSignals(e =>
                {
                    PhidgetUtility.EnsureOutput(e, 2, false);   // Power を離す
                    Task.Delay(500).Wait();
                    PhidgetUtility.EnsureOutput(e, 0, false);   // VolUp を離す
                    Task.Delay(500).Wait();
                    PhidgetUtility.EnsureOutput(e, 0, true);    // VolUp を押す
                    Task.Delay(500).Wait();
                    PhidgetUtility.EnsureOutput(e, 2, true);    // Power を押す
                    Task.Delay(500).Wait();
                    PhidgetUtility.EnsureOutput(e, 2, false);   // Power を離す
                    Task.Delay(500).Wait();
                    PhidgetUtility.EnsureOutput(e, 0, false);   // VolUp を離す
                    Task.Delay(500).Wait();
                },
                SerialNumber, TimeSpan.FromMilliseconds(500));
            }

            if (WaitSeconds > 0)
            {
                Guid frcm = new Guid("EAD8C4F6-6102-45C7-AA66-36E6D7204600");
                List<UsbDevice> result = UsbDevice.WaitForDetectUsbDeviceByGuid(frcm, TimeSpan.FromSeconds(WaitSeconds));
                if (result.Count == 0)
                {
                    throw new Exception("found no frcm devices.");
                }
            }
        }
    }
}
