﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Nintendo.DebugBoardPlugin;
using Nintendo.Foundation.IO;
namespace Nintendo.ControlTarget
{
    public class DebugBoardPressPowerButtonCommand : CommandCommon
    {
        [CommandLineValue(0, ValueName = "hold-time", Description = "Hold Time (ms)")]
        public int HoldTime { get; set; } = 100;
        public override void Run()
        {
            DebugBoardUtility.SendSignals(e =>
            {
                e.PressPowerButton(false);
                Task.Delay(100).Wait();
                e.PressPowerButton(true);
                Task.Delay(HoldTime).Wait();
                e.PressPowerButton(false);
            });
        }
    }
}
