﻿using System;
using System.IO;
using System.Diagnostics;
using System.Reflection;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Nintendo.ControlTarget
{
    public class PathUtility
    {
        public static FileInfo GetHtcDaemonPath()
        {
            // TODO: Root 付近に置かれた設定ファイルに exe かツール群の場所を書いて参照する形に直すべき
            var root = FindSigloRoot(Assembly.GetExecutingAssembly().Location);
            var repositoryPath = new FileInfo(Path.Combine(root, @"Programs\Chris\Tools\Htc\HtcDaemon\HtcDaemon.exe"));
            var packagePath = new FileInfo(Path.Combine(root, @"Tools\Htc\HtcDaemon\HtcDamon.exe"));

            if (repositoryPath.Exists)
            {
                return repositoryPath;
            }
            else
            {
                return packagePath;
            }
        }

        public static void SetExtraTargetManagerDirectory(string path)
        {
            // path 直下に NintendoTargetManager.exe と TMCMD.exe があることを期待します
            extraTargetManagerDirectory = path;
        }

        public static FileInfo GetTargetManagerPath()
        {
            if (extraTargetManagerDirectory != null)
            {
                var extraPath = new FileInfo(Path.Combine(extraTargetManagerDirectory, @"NintendoTargetManager.exe"));
                if (extraPath.Exists)
                {
                    return extraPath;
                }
            }

            var root = FindSigloRoot(Assembly.GetExecutingAssembly().Location);
            var repositoryPath = new FileInfo(Path.Combine(root, @"Externals\Oasis\bin\NintendoTargetManager.exe"));
            var installPath = new FileInfo(@"C:\Program Files\Nintendo\Oasis\bin\NintendoTargetManager.exe");

            if (repositoryPath.Exists)
            {
                return repositoryPath;
            }
            if (installPath.Exists)
            {
                return installPath;
            }


            throw new Exception("TargetManager is not found");
        }

        public static string FindSigloRoot()
        {
            return FindSigloRoot(Assembly.GetExecutingAssembly().Location);
        }

        public static string FindSigloRoot(string path)
        {
            string startPath = path;
            string currentDirectory = startPath;
            string rootDirectory = Path.GetPathRoot(currentDirectory);

            while (rootDirectory != currentDirectory)
            {
                string sigloRootMarkFilePath = Path.Combine(currentDirectory, NintendoSdkRootMarkFileName);
                if (File.Exists(sigloRootMarkFilePath))
                {
                    return currentDirectory;
                }

                currentDirectory = Path.GetFullPath(System.IO.Path.Combine(currentDirectory, ".."));
            }

            throw new InvalidDataException(string.Format("{0} を見つけられませんでした。\nPath=\n{1}", NintendoSdkRootMarkFileName, startPath));
        }

        private const string NintendoSdkRootMarkFileName = "NintendoSdkRootMark";

        private static string extraTargetManagerDirectory = null;
    }
}
