﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Threading.Tasks.Dataflow;
using CommandUtility;

namespace Nintendo.ControlTarget
{
    public class DataflowConsole : Singleton<DataflowConsole>
    {
        public void ExitHandler()
        {
        }

        public void Ignore()
        {
        }

        public DataflowConsole()
        {
            DataflowUtility.LinkBlock("mergingTarget->consoleTarget", mergingTarget, consoleTarget);
            mergingTarget.Post(new Tuple<string, string>("", ""));
            AppDomain.CurrentDomain.ProcessExit += new EventHandler((o, e) => { this.ExitHandler(); });
        }

        public void SetOption(bool enableArrangedLog)
        {
            if (enableArrangedLog)
            {
                mergingTarget = DataflowUtility.CreateArrangementMultiLogBlock();
            }
            else
            {
                mergingTarget = DataflowUtility.CreateDelitionMetaBlock();
            }

            DataflowUtility.LinkBlock("mergingTarget->consoleTarget with set option", mergingTarget, consoleTarget);
        }

        public ITargetBlock<string> GetNamedTarget(string name)
        {
            return GetNamedTarget(name, name);
        }

        public ITargetBlock<string> GetNamedTarget(string id, string name)
        {
            if (!namedTarget.ContainsKey(id))
            {
                namedTarget[id] = DataflowUtility.CreateAdditionMetaBlock(name);
                DataflowUtility.LinkBlock(string.Format("namedTarget[id:{0}]->mergingTarget", id), namedTarget[id], mergingTarget);
            }

            return namedTarget[id];
        }

        public ITargetBlock<Tuple<string, string>> GetMergingTarget()
        {
            return mergingTarget;
        }

        public ITargetBlock<string> GetConsoleTarget()
        {
            return this.consoleTarget;
        }

        private ITargetBlock<string> consoleTarget = DataflowUtility.CreateStandardOutputTarget();
        private IPropagatorBlock<Tuple<string, string>, string> mergingTarget = DataflowUtility.CreateDelitionMetaBlock();
        private Dictionary<string, IPropagatorBlock<string, Tuple<string, string>>> namedTarget = new Dictionary<string, IPropagatorBlock<string, Tuple<string, string>>>();
    }
}
