﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Threading.Tasks.Dataflow;
using System.Diagnostics;

namespace Nintendo.ControlTarget
{
    /// <summary>
    /// Trace をとりあえず必要な形式で使えるようにしたもの。
    /// かなりの暫定実装
    /// </summary>
    public class ConsoleApplicationTraceListener : TraceListener
    {
        public ConsoleApplicationTraceListener(bool verbose)
        {
            Verbose = verbose;
        }

        public override void Write(string message)
        {
            if (Verbose)
            {
                var target = DataflowConsole.Instance.GetNamedTarget("trace");
                var completion = DataflowConsole.Instance.GetConsoleTarget().Completion;

                if (completion.IsCompleted || completion.IsCanceled || completion.IsFaulted)
                {
                    Console.Write($"{message}");
                }
                else
                {
                    target.Post(message);
                }
            }
        }

        public override void WriteLine(string message)
        {
            if (Verbose)
            {
                var target = DataflowConsole.Instance.GetNamedTarget("trace");
                var completion = DataflowConsole.Instance.GetConsoleTarget().Completion;

                if (completion.IsCompleted || completion.IsCanceled || completion.IsFaulted)
                {
                    Console.WriteLine($"[trace] {message}");
                }
                else
                {
                    target.Post($"{message}\r\n");
                }
            }
        }

        public static void SetGlobal(bool verbose)
        {
            var listener = new ConsoleApplicationTraceListener(verbose);
            listener.TraceOutputOptions = TraceOptions.None;

            Trace.Listeners.Remove("Default");
            Trace.Listeners.Add(listener);
        }

        private bool Verbose;
    }
}
