﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Diagnostics;
using Nintendo.Foundation.IO;

namespace Nintendo.ControlTarget
{
    public class WaitDetectCommand : CommandCommon
    {
        [CommandLineOption('t', "target",
            Description = "Set target name to run the program. (See targets with 'ControlTarget.exe list-taget')",
            IsRequired = true)]
        public string Target { get; set; }

        [CommandLineOption("timeout",
            Description = "Set timeout of detecting targets as seconds.",
            DefaultValue = 20)]
        public int Timeout { get; set; }

        public override void Run()
        {
            RunCommand(
                () =>
                {
                    using (var tmapiAccessor = new TargetManagerAccessor())
                    {
                        tmapiAccessor.EnsureStart();

                        TimeSpan restTime = TimeSpan.FromSeconds(Timeout);
                        while (0 < restTime.TotalMilliseconds)
                        {
                            var waitTime = TimeSpan.FromMilliseconds(Math.Min(restTime.TotalMilliseconds, 2000.0));

                            if (tmapiAccessor.DetectTarget(Target, waitTime) != null)
                            {
                                Trace.WriteLine($"Found the target. name = {Target}");
                                return;
                            }

                            restTime -= waitTime;
                        }

                        throw new Exception(string.Format("Found no targets. name = {0}", Target));
                    }
                });
        }
    }
}
