﻿using Nintendo.Foundation.IO;

namespace Nintendo.ControlTarget
{
    public class UninstallApplicationCommand : CommonDevMenuCommandCommand
    {
        [CommandLineValue(0, ValueName = "Application id", Description = "Specifies Application ID to uninstall.")]
        public string ApplicationId { get; set; }

        public override void Run()
        {
            RunDevMenuCommandCommand(() => {
                RunDevMenuCommand(
                    "application",
                    "uninstall",
                    ApplicationId);
            });
        }
    }
}
