﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Nintendo.Foundation.IO;

namespace Nintendo.ControlTarget
{
    public class SetNameCommand : CommonTargetCommand
    {
        [CommandLineValue(0,
            Description = "Set the target name.",
            ValueName = "Name",
            IsRequired = false)]
        public string Name { get; set; }

        public override void Run()
        {
            RunHostBridgeTargetCommand(
                (name, info, target, tmapiAccessor) =>
                {
                    if (Name != null)
                    {
                        target.SetName(Name);
                    }
                    else if (info.GetSerialNumber() != "Unknown")
                    {
                        target.SetName(info.GetSerialNumber());
                    }
                    else
                    {
                        target.SetName(info.GetMacAddress().Replace(":", "-").ToUpper());
                    }
                });
        }
    }
}
